/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.model.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.model.preferences.BrowserSimSpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.vpe.browsersim.util.BrowserSimResourcesUtil;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BrowserSimSpecificPreferencesStorage
extends SpecificPreferencesStorage {
    private static final int CURRENT_CONFIG_VERSION = 12;
    private static final String SPECIFIC_PREFERENCES_FILE = "specificPreferences.xml";
    private static final String DEFAULT_SPECIFIC_PREFERENCES_RESOURCE = "config/specificPreferences.xml";
    public static BrowserSimSpecificPreferencesStorage INSTANCE = new BrowserSimSpecificPreferencesStorage();

    @Override
    protected SpecificPreferences load(InputStream is) {
        int configVersion = 0;
        String selectedDeviceId = null;
        int orientationAngle = 0;
        Point currentlocation = null;
        boolean useSkins = true;
        boolean enableLiveReload = false;
        int liveReloadPort = 35729;
        boolean enableTouchEvents = false;
        boolean isJavaFx = !BrowserSimArgs.standalone;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(is);
            document.getDocumentElement().normalize();
            configVersion = Integer.parseInt(document.getDocumentElement().getAttribute("version"));
            if (configVersion == 12) {
                Node node = document.getElementsByTagName("selectedDeviceId").item(0);
                if (!PreferencesUtil.isNullOrEmpty(node)) {
                    selectedDeviceId = node.getTextContent();
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("useSkins").item(0))) {
                    useSkins = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("enableLiveReload").item(0))) {
                    enableLiveReload = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("liveReloadPort").item(0))) {
                    liveReloadPort = Integer.parseInt(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("enableTouchEvents").item(0))) {
                    enableTouchEvents = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("orientationAngle").item(0))) {
                    orientationAngle = Integer.parseInt(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("javafx").item(0))) {
                    isJavaFx = Boolean.parseBoolean(node.getTextContent());
                }
                if (!PreferencesUtil.isNullOrEmpty(node = document.getElementsByTagName("location").item(0)) && node.getNodeType() == 1) {
                    Element location = (Element)node;
                    Node x = location.getElementsByTagName("x").item(0);
                    Node y = location.getElementsByTagName("y").item(0);
                    if (!PreferencesUtil.isNullOrEmpty(x) && !PreferencesUtil.isNullOrEmpty(y)) {
                        currentlocation = new Point(Integer.parseInt(x.getTextContent()), Integer.parseInt(y.getTextContent()));
                    }
                }
                BrowserSimSpecificPreferences browserSimSpecificPreferences = new BrowserSimSpecificPreferences(selectedDeviceId, useSkins, enableLiveReload, liveReloadPort, enableTouchEvents, orientationAngle, currentlocation, isJavaFx);
                return browserSimSpecificPreferences;
            }
        }
        catch (SAXException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (FactoryConfigurationError e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                BrowserSimLogger.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    protected void save(SpecificPreferences sp, File file) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("browserSim");
            rootElement.setAttribute("version", String.valueOf(12));
            doc.appendChild(rootElement);
            Element selectedDevice = doc.createElement("selectedDeviceId");
            selectedDevice.setTextContent(String.valueOf(sp.getSelectedDeviceId()));
            rootElement.appendChild(selectedDevice);
            Element location = doc.createElement("location");
            Element locationX = doc.createElement("x");
            Element locationY = doc.createElement("y");
            Point currentLocation = sp.getLocation();
            locationX.setTextContent(String.valueOf(currentLocation.x));
            locationY.setTextContent(String.valueOf(currentLocation.y));
            location.appendChild(locationX);
            location.appendChild(locationY);
            rootElement.appendChild(location);
            Element orientationAngle = doc.createElement("orientationAngle");
            orientationAngle.setTextContent(String.valueOf(sp.getOrientationAngle()));
            rootElement.appendChild(orientationAngle);
            Element useSkins = doc.createElement("useSkins");
            useSkins.setTextContent(String.valueOf(sp.getUseSkins()));
            rootElement.appendChild(useSkins);
            Element enableLiveReload = doc.createElement("enableLiveReload");
            enableLiveReload.setTextContent(String.valueOf(sp.isEnableLiveReload()));
            rootElement.appendChild(enableLiveReload);
            Element liveReloadPort = doc.createElement("liveReloadPort");
            liveReloadPort.setTextContent(String.valueOf(sp.getLiveReloadPort()));
            rootElement.appendChild(liveReloadPort);
            Element enableTouchEvents = doc.createElement("enableTouchEvents");
            enableTouchEvents.setTextContent(String.valueOf(sp.isEnableTouchEvents()));
            rootElement.appendChild(enableTouchEvents);
            Element isJavaFx = doc.createElement("javafx");
            isJavaFx.setTextContent(String.valueOf(sp.isJavaFx()));
            rootElement.appendChild(isJavaFx);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.newTransformer().transform(new DOMSource(doc), new StreamResult(file));
        }
        catch (ParserConfigurationException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        catch (TransformerException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
    }

    @Override
    protected SpecificPreferences createBlankPreferences() {
        return new BrowserSimSpecificPreferences(null, true, false, 35729, false, 0, null, false);
    }

    @Override
    protected SpecificPreferencesStorage getInstance() {
        return INSTANCE;
    }

    @Override
    protected String getFileName() {
        return SPECIFIC_PREFERENCES_FILE;
    }

    @Override
    protected InputStream getDefaultPreferencesFileAsStream() {
        return BrowserSimResourcesUtil.getResourceAsStream(DEFAULT_SPECIFIC_PREFERENCES_RESOURCE);
    }
}

