/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeContentProvider;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeLabelProvider;

public class RuntimeCheckboxTreeViewer
extends CheckboxTreeViewer {
    public RuntimeCheckboxTreeViewer(Composite parent, Set<RuntimePath> runtimePaths2, int heightHint) {
        this(parent, runtimePaths2.toArray(new RuntimePath[runtimePaths2.size()]), heightHint);
    }

    public RuntimeCheckboxTreeViewer(Composite parent, RuntimePath[] runtimePaths2, int heightHint) {
        super(parent, 68100);
        Tree tree = this.getTree();
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gd.minimumHeight = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightHint);
        tree.setLayoutData((Object)gd);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.RuntimeCheckboxTreeViewer_Name, Messages.RuntimeCheckboxTreeViewer_Type, Messages.RuntimeCheckboxTreeViewer_Version, Messages.RuntimeCheckboxTreeViewer_Location};
        int[] columnWidths = new int[]{300, 100, 50, 200};
        int i = 0;
        while (i < columnNames.length) {
            TreeViewerColumn tc = new TreeViewerColumn((TreeViewer)this, 0);
            tc.getColumn().setText(columnNames[i]);
            tc.getColumn().setWidth(columnWidths[i]);
            ++i;
        }
        this.setLabelProvider((IBaseLabelProvider)new RuntimeLabelProvider());
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        RuntimePath[] runtimePathArray = runtimePaths2;
        int n = runtimePaths2.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            runtimeDefinitions.addAll(Arrays.asList(runtimePath.getRuntimeDefinitions()));
            ++n2;
        }
        this.setContentProvider((IContentProvider)new RuntimeContentProvider(runtimeDefinitions));
        this.setInput(runtimeDefinitions);
        for (RuntimeDefinition definition : runtimeDefinitions) {
            this.setChecked(definition, definition.isEnabled());
        }
    }

    public void updateInput(RuntimePath[] runtimePaths) {
        this.setInput(null);
        ArrayList<RuntimeDefinition> runtimeDefinitions = new ArrayList<RuntimeDefinition>();
        RuntimePath[] runtimePathArray = runtimePaths;
        int n = runtimePaths.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimePath runtimePath = runtimePathArray[n2];
            runtimeDefinitions.addAll(Arrays.asList(runtimePath.getRuntimeDefinitions()));
            ++n2;
        }
        this.setInput(runtimeDefinitions);
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            this.setChecked(runtimeDefinition, runtimeDefinition.isEnabled());
        }
    }
}

