/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.ui.internal.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.runtime.ui.internal.Messages;
import org.jboss.tools.runtime.ui.internal.dialogs.RuntimeCheckboxTreeViewer;
import org.jboss.tools.runtime.ui.internal.dialogs.SearchRuntimePathDialog;

public class EditRuntimePathDialog
extends Dialog {
    private RuntimePath runtimePath;
    private RuntimeCheckboxTreeViewer treeViewer;

    public EditRuntimePathDialog(Shell parentShell, RuntimePath runtimePath) {
        super(parentShell);
        this.setShellStyle(0xC70 | EditRuntimePathDialog.getDefaultOrientation());
        this.runtimePath = runtimePath;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditRuntimePathDialog_Edit_runtime_detection_path);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 700;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(1, false));
        EditRuntimePathDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Composite pathComposite = new Composite(contents, 0);
        gd = new GridData(4, 4, true, false);
        pathComposite.setLayoutData((Object)gd);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        Label pathLabel = new Label(pathComposite, 0);
        pathLabel.setText(Messages.EditRuntimePathDialog_Path);
        final Text pathText = new Text(pathComposite, 2048);
        gd = new GridData(4, 4, true, false);
        pathText.setLayoutData((Object)gd);
        pathText.setText(this.runtimePath.getPath());
        Button browseButton = new Button(pathComposite, 0);
        browseButton.setText(Messages.EditRuntimePathDialog_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDialogSettings dialogSettings = RuntimeUIActivator.getDefault().getDialogSettings();
                DirectoryDialog dialog = new DirectoryDialog(EditRuntimePathDialog.this.getShell());
                dialog.setMessage(Messages.EditRuntimePathDialog_Edit_Path);
                dialog.setFilterPath(pathText.getText());
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                EditRuntimePathDialog.this.runtimePath.setPath(path);
                dialogSettings.put("lastPath", path);
                pathText.setText(path);
                EditRuntimePathDialog.refreshRuntimes(EditRuntimePathDialog.this.getShell(), new RuntimePath[]{EditRuntimePathDialog.this.runtimePath}, EditRuntimePathDialog.this.treeViewer, false);
            }
        });
        Label refreshLabel = new Label(pathComposite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        refreshLabel.setLayoutData((Object)gd);
        refreshLabel.setText(Messages.EditRuntimePathDialog_Runtimes_found_at_this_path);
        final Button refreshButton = new Button(pathComposite, 0);
        refreshButton.setText(Messages.EditRuntimePathDialog_Refresh);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRuntimePathDialog.refreshRuntimes(EditRuntimePathDialog.this.getShell(), new RuntimePath[]{EditRuntimePathDialog.this.runtimePath}, EditRuntimePathDialog.this.treeViewer, false);
            }
        });
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditRuntimePathDialog.this.runtimePath.setPath(pathText.getText());
                if (!pathText.getText().isEmpty()) {
                    refreshButton.setEnabled(new File(pathText.getText()).isDirectory());
                }
            }
        });
        refreshButton.setEnabled(new File(pathText.getText()).isDirectory());
        this.treeViewer = this.createRuntimeViewer(new RuntimePath[]{this.runtimePath}, contents, 100);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RuntimeDefinition definition;
                definition.setEnabled(!(definition = (RuntimeDefinition)event.getElement()).isEnabled());
            }
        });
        return area;
    }

    private RuntimeCheckboxTreeViewer createRuntimeViewer(RuntimePath[] runtimePaths2, Composite composite, int heightHint) {
        return new RuntimeCheckboxTreeViewer(composite, runtimePaths2, heightHint);
    }

    public static void refreshRuntimes(Shell shell, final RuntimePath[] runtimePaths, final RuntimeCheckboxTreeViewer viewer, boolean needRefresh) {
        SearchRuntimePathDialog dialog = SearchRuntimePathDialog.launchSearchRuntimePathDialog(shell, runtimePaths, needRefresh, 15);
        if (viewer != null) {
            dialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    viewer.updateInput(runtimePaths);
                }
            });
        }
    }
}

