/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.jboss.tools.hibernate.proxy.TypeProxy;
import org.jboss.tools.hibernate.spi.ITable;
import org.jboss.tools.hibernate.spi.IType;
import org.jboss.tools.hibernate.spi.ITypeFactory;

public class TypeFactoryProxy
implements ITypeFactory {
    private Map<IType, String> typeFormats = null;

    public IType getBooleanType() {
        return new TypeProxy((Type)Hibernate.BOOLEAN);
    }

    public IType getByteType() {
        return new TypeProxy((Type)Hibernate.BYTE);
    }

    public IType getBigIntegerType() {
        return new TypeProxy((Type)Hibernate.BIG_INTEGER);
    }

    public IType getShortType() {
        return new TypeProxy((Type)Hibernate.SHORT);
    }

    public IType getCalendarType() {
        return new TypeProxy((Type)Hibernate.CALENDAR);
    }

    public IType getCalendarDateType() {
        return new TypeProxy((Type)Hibernate.CALENDAR_DATE);
    }

    public IType getIntegerType() {
        return new TypeProxy((Type)Hibernate.INTEGER);
    }

    public IType getBigDecimalType() {
        return new TypeProxy((Type)Hibernate.BIG_DECIMAL);
    }

    public IType getCharacterType() {
        return new TypeProxy((Type)Hibernate.CHARACTER);
    }

    public IType getClassType() {
        return new TypeProxy((Type)Hibernate.CLASS);
    }

    public IType getCurrencyType() {
        return new TypeProxy((Type)Hibernate.CURRENCY);
    }

    public IType getDateType() {
        return new TypeProxy((Type)Hibernate.DATE);
    }

    public IType getDoubleType() {
        return new TypeProxy((Type)Hibernate.DOUBLE);
    }

    public IType getFloatType() {
        return new TypeProxy((Type)Hibernate.FLOAT);
    }

    public IType getLocaleType() {
        return new TypeProxy((Type)Hibernate.LOCALE);
    }

    public IType getLongType() {
        return new TypeProxy((Type)Hibernate.LONG);
    }

    public IType getStringType() {
        return new TypeProxy((Type)Hibernate.STRING);
    }

    public IType getTextType() {
        return new TypeProxy((Type)Hibernate.TEXT);
    }

    public IType getTimeType() {
        return new TypeProxy((Type)Hibernate.TIME);
    }

    public IType getTimestampType() {
        return new TypeProxy((Type)Hibernate.TIMESTAMP);
    }

    public IType getTimezoneType() {
        return new TypeProxy((Type)Hibernate.TIMEZONE);
    }

    public IType getTrueFalseType() {
        return new TypeProxy((Type)Hibernate.TRUE_FALSE);
    }

    public IType getYesNoType() {
        return new TypeProxy((Type)Hibernate.YES_NO);
    }

    public IType getNamedType(String typeName) {
        return new TypeProxy(TypeFactory.heuristicType((String)typeName));
    }

    public IType getBasicType(String type) {
        return new TypeProxy(TypeFactory.basic((String)type));
    }

    public Map<IType, String> getTypeFormats() {
        if (this.typeFormats == null) {
            this.initializeTypeFormats();
        }
        return this.typeFormats;
    }

    private void initializeTypeFormats() {
        this.typeFormats = new HashMap<IType, String>();
        this.addTypeFormat(this.getBooleanType(), Boolean.TRUE);
        this.addTypeFormat(this.getByteType(), (byte)42);
        this.addTypeFormat(this.getBigIntegerType(), BigInteger.valueOf(42L));
        this.addTypeFormat(this.getShortType(), (short)42);
        this.addTypeFormat(this.getCalendarType(), new GregorianCalendar());
        this.addTypeFormat(this.getCalendarDateType(), new GregorianCalendar());
        this.addTypeFormat(this.getIntegerType(), 42);
        this.addTypeFormat(this.getBigDecimalType(), new BigDecimal(42.0));
        this.addTypeFormat(this.getCharacterType(), Character.valueOf('h'));
        this.addTypeFormat(this.getClassType(), ITable.class);
        this.addTypeFormat(this.getCurrencyType(), Currency.getInstance(Locale.getDefault()));
        this.addTypeFormat(this.getDateType(), new Date());
        this.addTypeFormat(this.getDoubleType(), 42.42);
        this.addTypeFormat(this.getFloatType(), Float.valueOf(42.42f));
        this.addTypeFormat(this.getLocaleType(), Locale.getDefault());
        this.addTypeFormat(this.getLongType(), 42L);
        this.addTypeFormat(this.getStringType(), "a string");
        this.addTypeFormat(this.getTextType(), "a text");
        this.addTypeFormat(this.getTimeType(), new Date());
        this.addTypeFormat(this.getTimestampType(), new Date());
        this.addTypeFormat(this.getTimezoneType(), TimeZone.getDefault());
        this.addTypeFormat(this.getTrueFalseType(), Boolean.TRUE);
        this.addTypeFormat(this.getYesNoType(), Boolean.TRUE);
    }

    private void addTypeFormat(IType type, Object value) {
        this.typeFormats.put(type, type.toString(value));
    }
}

