/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.jboss.tools.hibernate.proxy.ColumnProxy;
import org.jboss.tools.hibernate.proxy.ForeignKeyProxy;
import org.jboss.tools.hibernate.proxy.PrimaryKeyProxy;
import org.jboss.tools.hibernate.proxy.ValueProxy;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IForeignKey;
import org.jboss.tools.hibernate.spi.IPrimaryKey;
import org.jboss.tools.hibernate.spi.ITable;
import org.jboss.tools.hibernate.spi.IValue;

public class TableProxy
implements ITable {
    private Table target = null;
    private HashSet<IColumn> columns = null;
    private IValue identifierValue = null;
    private IPrimaryKey primaryKey = null;
    private HashSet<IForeignKey> foreignKeys = null;

    public TableProxy(Table table) {
        this.target = table;
    }

    public String getName() {
        return this.target.getName();
    }

    public Table getTarget() {
        return this.target;
    }

    public void addColumn(IColumn column) {
        assert (column instanceof ColumnProxy);
        this.target.addColumn(((ColumnProxy)column).getTarget());
        this.columns = null;
    }

    public void setPrimaryKey(IPrimaryKey pk) {
        assert (pk instanceof PrimaryKeyProxy);
        this.primaryKey = pk;
        this.target.setPrimaryKey(((PrimaryKeyProxy)pk).getTarget());
    }

    public String getCatalog() {
        return this.target.getCatalog();
    }

    public String getSchema() {
        return this.target.getSchema();
    }

    public IPrimaryKey getPrimaryKey() {
        if (this.primaryKey == null && this.target.getPrimaryKey() != null) {
            this.primaryKey = new PrimaryKeyProxy(this.target.getPrimaryKey());
        }
        return this.primaryKey;
    }

    public Iterator<IColumn> getColumnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    private void initializeColumns() {
        this.columns = new HashSet();
        Iterator iterator = this.target.getColumnIterator();
        while (iterator.hasNext()) {
            this.columns.add(new ColumnProxy((Column)iterator.next()));
        }
    }

    public Iterator<IForeignKey> getForeignKeyIterator() {
        if (this.foreignKeys == null) {
            this.initializeForeignKeys();
        }
        return this.foreignKeys.iterator();
    }

    private void initializeForeignKeys() {
        this.foreignKeys = new HashSet();
        Iterator origin = this.target.getForeignKeyIterator();
        while (origin.hasNext()) {
            this.foreignKeys.add(new ForeignKeyProxy((ForeignKey)origin.next()));
        }
    }

    public String getComment() {
        return this.target.getComment();
    }

    public String getRowId() {
        return this.target.getRowId();
    }

    public String getSubselect() {
        return this.target.getSubselect();
    }

    public boolean hasDenormalizedTables() {
        return this.target.hasDenormalizedTables();
    }

    public boolean isAbstract() {
        return this.target.isAbstract();
    }

    public boolean isAbstractUnionTable() {
        return this.target.isAbstractUnionTable();
    }

    public boolean isPhysicalTable() {
        return this.target.isPhysicalTable();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o != null & o.getClass() == this.getClass()) {
            result = ((TableProxy)o).getTarget().equals(this.getTarget());
        }
        return result;
    }

    public IValue getIdentifierValue() {
        if (this.identifierValue == null && this.target.getIdentifierValue() != null) {
            this.identifierValue = new ValueProxy((Value)this.target.getIdentifierValue());
        }
        return this.identifierValue;
    }
}

