/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Value;
import org.jboss.tools.hibernate.proxy.JoinProxy;
import org.jboss.tools.hibernate.proxy.PropertyProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.proxy.ValueProxy;
import org.jboss.tools.hibernate.spi.IJoin;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.ITable;
import org.jboss.tools.hibernate.spi.IValue;

public class PersistentClassProxy
implements IPersistentClass {
    private PersistentClass target = null;
    private IPersistentClass rootClass = null;
    private IPersistentClass superClass = null;
    private ITable table = null;
    private ITable rootTable = null;
    private IValue discriminator = null;
    private IValue identifier = null;
    private IProperty version = null;
    private IProperty identifierProperty = null;
    private HashSet<IPersistentClass> subclasses = null;
    private HashSet<IJoin> joins = null;
    private HashSet<IProperty> propertyClosures = null;
    private HashMap<String, IProperty> properties = null;

    public PersistentClassProxy(PersistentClass persistentClass) {
        this.target = persistentClass;
    }

    public PersistentClass getTarget() {
        return this.target;
    }

    public String getClassName() {
        return this.target.getClassName();
    }

    public String getEntityName() {
        return this.target.getEntityName();
    }

    public boolean isAssignableToRootClass() {
        return RootClass.class.isAssignableFrom(this.target.getClass());
    }

    public boolean isRootClass() {
        return this.target.getClass() == RootClass.class;
    }

    public IProperty getIdentifierProperty() {
        if (this.identifierProperty == null && this.target.getIdentifierProperty() != null) {
            this.identifierProperty = new PropertyProxy(this.target.getIdentifierProperty());
        }
        return this.identifierProperty;
    }

    public boolean hasIdentifierProperty() {
        return this.target.hasIdentifierProperty();
    }

    public boolean isInstanceOfRootClass() {
        return this.target instanceof RootClass;
    }

    public boolean isInstanceOfSubclass() {
        return this.target instanceof Subclass;
    }

    public String getNodeName() {
        return this.target.getNodeName();
    }

    public IPersistentClass getRootClass() {
        if (this.rootClass == null && this.target.getRootClass() != null) {
            this.rootClass = new PersistentClassProxy((PersistentClass)this.target.getRootClass());
        }
        return this.rootClass;
    }

    public Iterator<IProperty> getPropertyClosureIterator() {
        if (this.propertyClosures == null) {
            this.initializePropertyClosures();
        }
        return this.propertyClosures.iterator();
    }

    private void initializePropertyClosures() {
        this.propertyClosures = new HashSet();
        Iterator origin = this.target.getPropertyClosureIterator();
        while (origin.hasNext()) {
            this.propertyClosures.add(new PropertyProxy((Property)origin.next()));
        }
    }

    public IPersistentClass getSuperclass() {
        if (this.superClass != null) {
            this.superClass = new PersistentClassProxy(this.target.getSuperclass());
        }
        return this.superClass;
    }

    public Iterator<IProperty> getPropertyIterator() {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.values().iterator();
    }

    private void initializeProperties() {
        this.properties = new HashMap();
        Iterator origin = this.target.getPropertyIterator();
        while (origin.hasNext()) {
            Property property = (Property)origin.next();
            this.properties.put(property.getName(), new PropertyProxy(property));
        }
    }

    public IProperty getProperty(String string) {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.get(string);
    }

    public ITable getTable() {
        if (this.table == null && this.target.getTable() != null) {
            this.table = new TableProxy(this.target.getTable());
        }
        return this.table;
    }

    public Boolean isAbstract() {
        return this.target.isAbstract();
    }

    public IValue getDiscriminator() {
        if (this.discriminator == null && this.target.getDiscriminator() != null) {
            this.discriminator = new ValueProxy(this.target.getDiscriminator());
        }
        return this.discriminator;
    }

    public IValue getIdentifier() {
        if (this.identifier == null && this.target.getIdentifier() != null) {
            this.identifier = new ValueProxy((Value)this.target.getIdentifier());
        }
        return this.identifier;
    }

    public Iterator<IJoin> getJoinIterator() {
        if (this.joins == null) {
            this.initializeJoins();
        }
        return this.joins.iterator();
    }

    private void initializeJoins() {
        this.joins = new HashSet();
        Iterator origin = this.target.getJoinIterator();
        while (origin.hasNext()) {
            this.joins.add(new JoinProxy((Join)origin.next()));
        }
    }

    public IProperty getVersion() {
        if (this.version == null && this.target.getVersion() != null) {
            this.version = new PropertyProxy(this.target.getVersion());
        }
        return this.version;
    }

    public void setClassName(String className) {
        this.target.setClassName(className);
    }

    public void setEntityName(String entityName) {
        this.target.setEntityName(entityName);
    }

    public void setDiscriminatorValue(String value) {
        this.target.setDiscriminatorValue(value);
    }

    public void setAbstract(boolean b) {
        this.target.setAbstract(Boolean.valueOf(b));
    }

    public void addProperty(IProperty property) {
        assert (property instanceof PropertyProxy);
        this.target.addProperty(((PropertyProxy)property).getTarget());
        this.properties = null;
        this.propertyClosures = null;
    }

    public boolean isInstanceOfJoinedSubclass() {
        return this.target instanceof JoinedSubclass;
    }

    public void setTable(ITable table) {
        assert (this.target instanceof JoinedSubclass || this.target instanceof RootClass);
        assert (table instanceof TableProxy);
        if (this.target instanceof RootClass) {
            ((RootClass)this.target).setTable(((TableProxy)table).getTarget());
        } else if (this.target instanceof JoinedSubclass) {
            ((JoinedSubclass)this.target).setTable(((TableProxy)table).getTarget());
        }
    }

    public void setKey(IValue value) {
        assert (this.target instanceof JoinedSubclass);
        assert (value instanceof ValueProxy);
        assert (((ValueProxy)value).getTarget() instanceof KeyValue);
        ((JoinedSubclass)this.target).setKey((KeyValue)((ValueProxy)value).getTarget());
    }

    public boolean isInstanceOfSpecialRootClass() {
        return false;
    }

    public IProperty getProperty() {
        throw new RuntimeException("getProperty() is only allowed on SpecialRootClass");
    }

    public IProperty getParentProperty() {
        throw new RuntimeException("getProperty() is only allowed on SpecialRootClass");
    }

    public void setIdentifierProperty(IProperty property) {
        assert (this.target instanceof RootClass);
        assert (property instanceof PropertyProxy);
        ((RootClass)this.target).setIdentifierProperty(((PropertyProxy)property).getTarget());
        this.identifierProperty = property;
    }

    public void setIdentifier(IValue value) {
        assert (value instanceof ValueProxy);
        assert (((ValueProxy)value).getTarget() instanceof KeyValue);
        assert (this.target instanceof RootClass);
        ((RootClass)this.target).setIdentifier((KeyValue)((ValueProxy)value).getTarget());
    }

    public void setDiscriminator(IValue discr) {
        assert (this.target instanceof RootClass);
        assert (discr instanceof ValueProxy);
        ((RootClass)this.target).setDiscriminator(((ValueProxy)discr).getTarget());
    }

    public void setProxyInterfaceName(String name) {
        this.target.setProxyInterfaceName(name);
    }

    public void setLazy(boolean b) {
        this.target.setLazy(b);
    }

    public Iterator<IPersistentClass> getSubclassIterator() {
        if (this.subclasses == null) {
            this.initializeSubclasses();
        }
        return this.subclasses.iterator();
    }

    private void initializeSubclasses() {
        Iterator origin = this.target.getSubclassIterator();
        this.subclasses = new HashSet();
        while (origin.hasNext()) {
            this.subclasses.add(new PersistentClassProxy((PersistentClass)((Subclass)origin.next())));
        }
    }

    public boolean isCustomDeleteCallable() {
        return this.target.isCustomDeleteCallable();
    }

    public boolean isCustomInsertCallable() {
        return this.target.isCustomInsertCallable();
    }

    public boolean isCustomUpdateCallable() {
        return this.target.isCustomUpdateCallable();
    }

    public boolean isDiscriminatorInsertable() {
        return this.target.isDiscriminatorInsertable();
    }

    public boolean isDiscriminatorValueNotNull() {
        return this.target.isDiscriminatorValueNotNull();
    }

    public boolean isDiscriminatorValueNull() {
        return this.target.isDiscriminatorValueNull();
    }

    public boolean isExplicitPolymorphism() {
        return this.target.isExplicitPolymorphism();
    }

    public boolean isForceDiscriminator() {
        return this.target.isForceDiscriminator();
    }

    public boolean isInherited() {
        return this.target.isInherited();
    }

    public boolean isJoinedSubclass() {
        return this.target.isJoinedSubclass();
    }

    public boolean isLazy() {
        return this.target.isLazy();
    }

    public boolean isLazyPropertiesCacheable() {
        return this.target.isLazyPropertiesCacheable();
    }

    public boolean isMutable() {
        return this.target.isMutable();
    }

    public boolean isPolymorphic() {
        return this.target.isPolymorphic();
    }

    public boolean isVersioned() {
        return this.target.isVersioned();
    }

    public int getBatchSize() {
        return this.target.getBatchSize();
    }

    public String getCacheConcurrencyStrategy() {
        return this.target.getCacheConcurrencyStrategy();
    }

    public String getCustomSQLDelete() {
        return this.target.getCustomSQLDelete();
    }

    public String getCustomSQLInsert() {
        return this.target.getCustomSQLInsert();
    }

    public String getCustomSQLUpdate() {
        return this.target.getCustomSQLUpdate();
    }

    public String getDiscriminatorValue() {
        return this.target.getDiscriminatorValue();
    }

    public String getLoaderName() {
        return this.target.getLoaderName();
    }

    public int getOptimisticLockMode() {
        return this.target.getOptimisticLockMode();
    }

    public String getTemporaryIdTableDDL() {
        return this.target.getTemporaryIdTableDDL();
    }

    public String getTemporaryIdTableName() {
        return this.target.getTemporaryIdTableName();
    }

    public String getWhere() {
        return this.target.getWhere();
    }

    public ITable getRootTable() {
        if (this.rootTable == null) {
            this.rootTable = new TableProxy(this.target.getRootTable());
        }
        return this.rootTable;
    }
}

