/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.impl.SessionFactoryImpl;
import org.jboss.tools.hibernate.proxy.QueryTranslatorProxy;
import org.jboss.tools.hibernate.proxy.SessionFactoryProxy;
import org.jboss.tools.hibernate.spi.IHQLQueryPlan;
import org.jboss.tools.hibernate.spi.IQueryTranslator;
import org.jboss.tools.hibernate.spi.ISessionFactory;

public class HQLQueryPlanProxy
implements IHQLQueryPlan {
    private HQLQueryPlan target = null;
    private IQueryTranslator[] translators = null;

    public HQLQueryPlanProxy(String hql, boolean shallow, ISessionFactory sessionFactory) {
        assert (sessionFactory instanceof SessionFactoryProxy);
        SessionFactoryImpl factory = (SessionFactoryImpl)((SessionFactoryProxy)sessionFactory).getTarget();
        Map enabledFilters = Collections.emptyMap();
        this.target = new HQLQueryPlan(hql, shallow, enabledFilters, (SessionFactoryImplementor)factory);
    }

    public IQueryTranslator[] getTranslators() {
        if (this.translators == null) {
            this.initializeTranslators();
        }
        return this.translators;
    }

    private void initializeTranslators() {
        QueryTranslator[] origin = this.target.getTranslators();
        ArrayList<QueryTranslatorProxy> destination = new ArrayList<QueryTranslatorProxy>(origin.length);
        QueryTranslator[] queryTranslatorArray = origin;
        int n = origin.length;
        int n2 = 0;
        while (n2 < n) {
            QueryTranslator translator = queryTranslatorArray[n2];
            destination.add(new QueryTranslatorProxy(translator));
            ++n2;
        }
        this.translators = destination.toArray(new IQueryTranslator[origin.length]);
    }
}

