/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikePartialbeanBindingConfiguration;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;

public class DeltaspikePartialbeanDefinitionContext
extends AbstractDefinitionContextExtension
implements DeltaspikeConstants {
    Map<String, DeltaspikePartialbeanBindingConfiguration> partialbeanBindingConfigurations = new HashMap<String, DeltaspikePartialbeanBindingConfiguration>();

    protected DeltaspikePartialbeanDefinitionContext copy(boolean clean) {
        DeltaspikePartialbeanDefinitionContext copy = new DeltaspikePartialbeanDefinitionContext();
        copy.root = this.root;
        if (!clean) {
            copy.partialbeanBindingConfigurations.putAll(this.partialbeanBindingConfigurations);
        }
        return copy;
    }

    protected void doApplyWorkingCopy() {
        DeltaspikePartialbeanDefinitionContext copy = (DeltaspikePartialbeanDefinitionContext)this.workingCopy;
        this.partialbeanBindingConfigurations = copy.partialbeanBindingConfigurations;
    }

    public void clean() {
        this.partialbeanBindingConfigurations.clear();
    }

    public void clean(IPath path) {
    }

    public void clean(String typeName) {
        this.partialbeanBindingConfigurations.remove(typeName);
        for (DeltaspikePartialbeanBindingConfiguration c : this.partialbeanBindingConfigurations.values()) {
            c.clear(typeName);
        }
    }

    public void computeAnnotationKind(AnnotationDefinition annotation) {
        if (annotation.isAnnotationPresent("org.apache.deltaspike.partialbean.api.PartialBeanBinding")) {
            annotation.setExtendedKind((Object)"partialbeanBindingAnnotation");
            String qn = annotation.getType().getFullyQualifiedName();
            DeltaspikePartialbeanBindingConfiguration c = this.getConfiguration(qn);
            c.setPartialbeanBindingTypeDefinition(annotation, this);
            if (!annotation.getType().isBinary()) {
                IPath newPath = annotation.getType().getResource().getFullPath();
                Set<IPath> ps = c.getInvolvedTypes();
                for (IPath p : ps) {
                    this.getRootContext().addDependency(p, newPath);
                    this.getRootContext().addDependency(newPath, p);
                }
                ps.add(newPath);
            }
        }
    }

    public DeltaspikePartialbeanBindingConfiguration getConfiguration(String typeName) {
        DeltaspikePartialbeanBindingConfiguration result = this.partialbeanBindingConfigurations.get(typeName);
        if (result == null) {
            result = new DeltaspikePartialbeanBindingConfiguration(typeName);
            this.partialbeanBindingConfigurations.put(typeName, result);
        }
        return result;
    }
}

