/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.internal.ui.console.TernConsole;
import tern.eclipse.ide.internal.ui.console.TernConsoleHelper;
import tern.eclipse.ide.internal.ui.descriptors.TernModuleDescriptorManager;
import tern.eclipse.ide.ui.console.ITernConsole;
import tern.eclipse.ide.ui.descriptors.ITernModuleDescriptorManager;

public class TernUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "tern.eclipse.ide.ui";
    private static TernUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        TernUIPlugin.getTernDescriptorManager().destroy();
        plugin = null;
        super.stop(context);
    }

    public static TernUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return TernUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = TernUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return TernUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public ITernConsole getConsole(IIDETernProject project) {
        if (project.isServerDisposed()) {
            return null;
        }
        TernConsole console = TernConsole.getOrCreateConsole(project);
        TernConsoleHelper.showConsole(console);
        return console;
    }

    public void closeConsole(IIDETernProject project) {
        TernConsole console = TernConsole.getConsole(project);
        if (console != null) {
            TernConsoleHelper.closeConsole(console);
        }
    }

    public static ITernModuleDescriptorManager getTernDescriptorManager() {
        return TernModuleDescriptorManager.getManager();
    }
}

