/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.preferences.PropertyPreferencePage;

public class TernDevelopmentPreferencesPage
extends PropertyPreferencePage {
    public static final String PROPERTY_PAGE_ID = "tern.eclipse.ide.ui.properties.TernDevelopmentPropertyPage";
    public static final String PREFERENCE_PAGE_ID = "tern.eclipse.ide.ui.preferences.TernDevelopmentPropertyPage";
    private final IPreferencesService fPreferencesService;
    private Button traceOnConsoleCheckbox;
    private Button loadingLocalPluginCheckbox;

    public TernDevelopmentPreferencesPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
        this.fPreferencesService = Platform.getPreferencesService();
    }

    @Override
    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        this.traceOnConsoleCheckbox = this.createCheckbox(page, "traceOnConsole", preferenceScopes, TernUIMessages.TernDevelopmentPreferencesPage_traceOnConsole_label);
        this.loadingLocalPluginCheckbox = this.createCheckbox(page, "loadingLocalPlugin", preferenceScopes, TernUIMessages.TernDevelopmentPreferencesPage_loadingLocalPlugin_label);
        return page;
    }

    private Button createCheckbox(Composite parent, String preferenceName, IScopeContext[] preferenceScopes, String label) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(label);
        checkbox.setLayoutData((Object)new GridData(32, 8, false, false, 1, 1));
        this.updateCheckbox(checkbox, preferenceName, preferenceScopes);
        return checkbox;
    }

    private void updateCheckbox(Button checkbox, String preferenceName, IScopeContext[] preferenceScopes) {
        boolean checked = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), preferenceName, true, preferenceScopes);
        checkbox.setSelection(checked);
    }

    private void updateCheckbox(Button checkbox, String preferenceName, IEclipsePreferences defaultPreferences) {
        boolean checked = defaultPreferences.getBoolean(preferenceName, false);
        checkbox.setSelection(checked);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        IEclipsePreferences defaultPreferences = this.createPreferenceScopes()[1].getNode(this.getPreferenceNodeQualifier());
        this.updateCheckbox(this.traceOnConsoleCheckbox, "traceOnConsole", defaultPreferences);
        this.updateCheckbox(this.loadingLocalPluginCheckbox, "loadingLocalPlugin", defaultPreferences);
    }

    @Override
    public boolean performOk() {
        boolean ok = super.performOk();
        IScopeContext[] contexts = this.createPreferenceScopes();
        IProject project = this.getProject();
        boolean remove = project != null && !this.isElementSettingsEnabled();
        this.updateContexts(this.traceOnConsoleCheckbox, "traceOnConsole", contexts, remove);
        this.updateContexts(this.loadingLocalPluginCheckbox, "loadingLocalPlugin", contexts, remove);
        this.flushContexts(contexts);
        if (project != null) {
            this.configureConsole(project);
        } else {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                this.configureConsole(projects[i]);
                ++i;
            }
        }
        return ok;
    }

    public void configureConsole(IProject project) {
        try {
            if (TernCorePlugin.hasTernNature((IProject)project)) {
                TernCorePlugin.getTernProject((IProject)project).configureConsole();
            }
        }
        catch (CoreException coreException) {}
    }

    private void updateContexts(Button checkbox, String preferenceName, IScopeContext[] contexts, boolean remove) {
        if (remove) {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove(preferenceName);
        } else {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(preferenceName, checkbox.getSelection());
        }
    }

    @Override
    protected String getPreferenceNodeQualifier() {
        return TernCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    @Override
    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    @Override
    protected String getProjectSettingsKey() {
        return "development-use-project-settings";
    }

    @Override
    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    public void init(IWorkbench workbencsh) {
    }
}

