/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.dialogs;

import java.io.File;
import java.util.Collection;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.repository.ITernRepository;
import tern.repository.TernRepository;
import tern.utils.StringUtils;

public class EditRepositoryDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text ternBaseDirText;
    private final Collection<ITernRepository> repositories;
    private ITernRepository repository;

    public EditRepositoryDialog(Shell parentShell, Collection<ITernRepository> repositories) {
        this(parentShell, repositories, null);
    }

    public EditRepositoryDialog(Shell parentShell, Collection<ITernRepository> repositories, ITernRepository repository) {
        super(parentShell);
        this.repository = repository;
        this.repositories = repositories;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        super.setTitle(TernUIMessages.EditRepositoryDialog_title);
        super.setMessage(TernUIMessages.EditRepositoryDialog_desc, 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createRepositoryName(container);
        this.createTernBaseDir(container);
        this.validate();
        return area;
    }

    private void createRepositoryName(Composite parent) {
        Label repositorylabel = new Label(parent, 0);
        repositorylabel.setText(TernUIMessages.EditRepositoryDialog_name_label);
        GridData dataRepository = new GridData();
        dataRepository.grabExcessHorizontalSpace = true;
        dataRepository.horizontalAlignment = 4;
        dataRepository.horizontalSpan = 2;
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)dataRepository);
        if (this.repository != null) {
            this.nameText.setEnabled(false);
            this.nameText.setText(this.repository.getName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EditRepositoryDialog.this.validate();
            }
        });
    }

    private void createTernBaseDir(Composite parent) {
        Label fileLabel = new Label(parent, 0);
        fileLabel.setText(TernUIMessages.EditRepositoryDialog_ternBaseDir_label);
        GridData dataFile = new GridData();
        dataFile.grabExcessHorizontalSpace = true;
        dataFile.horizontalAlignment = 4;
        this.ternBaseDirText = new Text(parent, 2048);
        this.ternBaseDirText.setLayoutData((Object)dataFile);
        if (this.repository != null) {
            this.ternBaseDirText.setText(this.repository.getTernBaseDirAsString());
        }
        this.ternBaseDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EditRepositoryDialog.this.validate();
            }
        });
        Button browseButton = new Button(parent, 0);
        browseButton.setText(TernUIMessages.Button_browse);
        final Shell shell = parent.getShell();
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(EditRepositoryDialog.this.ternBaseDirText.getText());
                dlg.setText(TernUIMessages.EditRepositoryDialog_directoryDialog_title);
                dlg.setMessage(TernUIMessages.EditRepositoryDialog_directoryDialog_desc);
                String dir = dlg.open();
                if (dir != null) {
                    EditRepositoryDialog.this.ternBaseDirText.setText(dir);
                }
            }
        });
    }

    private void validate() {
        String error = this.validateName();
        if (StringUtils.isEmpty((String)error)) {
            error = this.validateTernBaseDir();
        }
        this.setErrorMessage(error);
    }

    private String validateName() {
        String name = this.nameText.getText();
        if (StringUtils.isEmpty((String)name)) {
            return TernUIMessages.EditRepositoryDialog_name_required;
        }
        if (name.contains(";")) {
            return NLS.bind((String)TernUIMessages.EditRepositoryDialog_name_forbiddenToken, (Object)";");
        }
        if (this.repository == null && this.isRepositoryNameAlreadyExists(name)) {
            return NLS.bind((String)TernUIMessages.EditRepositoryDialog_name_alreadyExists, (Object)name);
        }
        return null;
    }

    private boolean isRepositoryNameAlreadyExists(String name) {
        for (ITernRepository repository : this.repositories) {
            if (!repository.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String validateTernBaseDir() {
        String ternBaseDir = this.ternBaseDirText.getText();
        if (StringUtils.isEmpty((String)ternBaseDir)) {
            return TernUIMessages.EditRepositoryDialog_ternBaseDir_required;
        }
        File dir = new File(ternBaseDir);
        if (!dir.exists()) {
            return TernUIMessages.EditRepositoryDialog_ternBaseDir_doesntExists;
        }
        if (!dir.isDirectory()) {
            return TernUIMessages.EditRepositoryDialog_ternBaseDir_notDir;
        }
        if (!this.exists(dir, "defs") || !this.exists(dir, "plugin")) {
            return TernUIMessages.EditRepositoryDialog_ternBaseDir_notValid;
        }
        return null;
    }

    private boolean exists(File dir, String name) {
        return new File(dir, name).exists();
    }

    protected void okPressed() {
        String name = this.nameText.getText();
        String file = this.ternBaseDirText.getText();
        if (this.repository == null) {
            this.repository = new TernRepository(name, new File(file));
        } else {
            this.repository.setTernBaseDir(new File(file));
        }
        super.okPressed();
    }

    public ITernRepository getRepository() {
        return this.repository;
    }
}

