/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jsf.web.ConfigFilesData;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public class JSFWebHelper {
    public static String PARAM_NAME = "param-name";
    public static String PARAM_VALUE = "param-value";
    public static ConfigFilesData FACES_CONFIG_DATA = new ConfigFilesData("javax.faces.CONFIG_FILES", new String[]{"/WEB-INF/faces-config.xml"});
    public static ConfigFilesData FACELET_TAGLIB_DATA = new ConfigFilesData("facelets.LIBRARIES", new String[0], ";");
    public static ConfigFilesData FACELETS_LIBRARIES = new ConfigFilesData("javax.faces.FACELETS_LIBRARIES", new String[0], ";");

    static {
        JSFWebHelper.FACES_CONFIG_DATA.usesDefaultWithoutRegistration = true;
    }

    public static XModelObject getWebConfig(XModel model) {
        return model.getByPath("/web.xml");
    }

    public static String[] getFacesConfigList(XModelObject webxml) {
        return JSFWebHelper.getConfigFilesList(webxml, FACES_CONFIG_DATA);
    }

    public static String getFacesConfigListAsString(XModelObject webxml) {
        return JSFWebHelper.getConfigFilesListAsString(webxml, FACES_CONFIG_DATA);
    }

    public static void registerFacesConfig(XModel model, String path) throws XModelException {
        JSFWebHelper.registerConfigFile(model, path, FACES_CONFIG_DATA);
    }

    public static boolean isRegisterFacesConfig(XModel model, String path) {
        return JSFWebHelper.isConfigFileRegistered(model, path, FACES_CONFIG_DATA);
    }

    public static void unregisterFacesConfig(XModel model, String path) throws XModelException {
        JSFWebHelper.unregisterConfigFile(model, path, FACES_CONFIG_DATA);
    }

    public static void registerFaceletsTaglib(XModel model, String path) throws XModelException {
        JSFWebHelper.registerConfigFile(model, path, FACELET_TAGLIB_DATA);
        JSFWebHelper.registerConfigFile(model, path, FACELETS_LIBRARIES);
    }

    public static XModelObject findInitParam(XModelObject webxml) {
        return JSFWebHelper.findInitParam(webxml, JSFWebHelper.FACES_CONFIG_DATA.param);
    }

    public static XModelObject findInitParam(XModelObject webxml, String name) {
        return WebAppHelper.findWebAppContextParam((XModelObject)webxml, (String)name);
    }

    public static void registerFacesConfigRename(XModel model, String oldConfigName, String newConfigName, String path) throws XModelException {
        JSFWebHelper.registerConfigFileRename(model, oldConfigName, newConfigName, path, FACES_CONFIG_DATA);
    }

    public static String[] getConfigFilesList(XModelObject webxml, ConfigFilesData data) {
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        return p == null ? data.defaultList : XModelObjectUtil.asStringArray((String)p.getAttributeValue("param-value"), (String)data.separator);
    }

    public static String[] getCompleteConfigFilesList(XModelObject webxml, ConfigFilesData data) {
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p == null) {
            return data.defaultList;
        }
        String[] ls = XModelObjectUtil.asStringArray((String)p.getAttributeValue("param-value"), (String)data.separator);
        if (ls.length == 0 || JSFWebHelper.arrayEquals(data.defaultList, ls)) {
            return data.defaultList;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < ls.length) {
            if (!list.contains(ls[i])) {
                list.add(ls[i]);
            }
            ++i;
        }
        i = 0;
        while (i < data.defaultList.length) {
            if (!list.contains(data.defaultList[i])) {
                list.add(data.defaultList[i]);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private static boolean arrayEquals(String[] a, String[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getConfigFilesListAsString(XModelObject webxml, ConfigFilesData data) {
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p != null) {
            String r = p.getAttributeValue("param-value");
            if (data.usesDefaultWithoutRegistration && data.defaultList != null) {
                int i = 0;
                while (i < data.defaultList.length) {
                    XModelObject o;
                    String path = data.defaultList[i];
                    if (("," + r + ",").indexOf("," + path + ",") < 0 && (o = XModelImpl.getByRelativePath((XModel)webxml.getModel(), (String)path)) != null) {
                        r = !r.startsWith(",") ? String.valueOf(path) + "," + r : String.valueOf(path) + r;
                    }
                    ++i;
                }
            }
            return r;
        }
        if (data.defaultList == null || data.defaultList.length == 0) {
            return "";
        }
        if (data.defaultList.length == 1) {
            return data.defaultList[0];
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.defaultList.length) {
            if (sb.length() > 0) {
                sb.append(data.separator.charAt(0));
            }
            sb.append(data.defaultList[i]);
            ++i;
        }
        return sb.toString();
    }

    public static void getConfigFiles(List<XModelObject> list, Set<XModelObject> set, XModel model, ConfigFilesData data) {
        XModelObject[] js;
        XModelObject webxml;
        String[] paths;
        FileSystemsImpl fs = (FileSystemsImpl)model.getByPath("FileSystems");
        if (fs != null) {
            fs.updateOverlapped();
        }
        if ((paths = JSFWebHelper.getCompleteConfigFilesList(webxml = JSFWebHelper.getWebConfig(model), data)) != null) {
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                XModelObject o = XModelImpl.getByRelativePath((XModel)model, (String)path);
                while (o == null) {
                    int d = path.indexOf("/", 1);
                    if (d < 0) break;
                    path = path.substring(d);
                    o = XModelImpl.getByRelativePath((XModel)model, (String)path);
                }
                if (o != null && !set.contains(o)) {
                    list.add(o);
                    set.add(o);
                }
                ++i;
            }
        }
        XModelObject[] xModelObjectArray = js = fs.getChildren("FileSystemJar");
        int n = js.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject o = xModelObjectArray[n2];
            XModelObject c = o.getChildByPath("META-INF/faces-config.xml");
            if (c != null && !set.contains(c)) {
                list.add(c);
                set.add(c);
            }
            ++n2;
        }
    }

    public static void registerConfigFile(XModel model, String path, ConfigFilesData data) throws XModelException {
        XModelObject webxml = JSFWebHelper.getWebConfig(model);
        if (webxml == null) {
            return;
        }
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p == null) {
            if (!data.usesDefaultWithoutRegistration && data.defaultList != null && data.defaultList.length > 0 && webxml.getModel().getByPath(data.defaultList[0]) != null) {
                String path0 = data.defaultList[0];
                path = String.valueOf(path0) + data.separator + path;
            }
            p = WebAppHelper.setWebAppContextParam((XModelObject)webxml, (String)data.param, (String)path);
        } else {
            String s = "" + data.separator.charAt(0);
            String v = p.getAttributeValue(PARAM_VALUE);
            if ((String.valueOf(s) + v + s).indexOf(String.valueOf(s) + path + s) < 0) {
                if (v.length() > 0 && !v.endsWith(s)) {
                    v = String.valueOf(v) + s;
                }
                v = String.valueOf(v) + path;
                model.changeObjectAttribute(p, PARAM_VALUE, v);
            }
        }
        if (webxml.isModified()) {
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)webxml, (Properties)new Properties());
        }
    }

    public static boolean isConfigFileDefault(String path, ConfigFilesData data) {
        if (data == null || data.defaultList == null) {
            return false;
        }
        int i = 0;
        while (i < data.defaultList.length) {
            if (data.defaultList[i].equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isConfigFileRegistered(XModel model, String path, ConfigFilesData data) {
        XModelObject webxml = JSFWebHelper.getWebConfig(model);
        if (webxml == null) {
            return false;
        }
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p == null) {
            return false;
        }
        String[] cs = JSFWebHelper.getConfigFilesList(webxml, data);
        int i = 0;
        while (i < cs.length) {
            if (cs[i].toLowerCase().endsWith(path.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void unregisterConfigFile(XModel model, String path, ConfigFilesData data) throws XModelException {
        XModelObject webxml = JSFWebHelper.getWebConfig(model);
        if (webxml == null) {
            return;
        }
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String[] cs = JSFWebHelper.getConfigFilesList(webxml, data);
        int i = 0;
        while (i < cs.length) {
            if (!cs[i].toLowerCase().equals(path.toLowerCase())) {
                if (sb.length() > 0) {
                    sb.append(data.separator.charAt(0));
                }
                sb.append(cs[i]);
            }
            ++i;
        }
        model.changeObjectAttribute(p, PARAM_VALUE, sb.toString());
    }

    public static void registerConfigFileRename(XModel model, String oldConfigName, String newConfigName, String path, ConfigFilesData data) throws XModelException {
        XModelObject webxml = JSFWebHelper.getWebConfig(model);
        if (webxml == null || "yes".equals(webxml.get("isIncorrect"))) {
            return;
        }
        XModelObject p = JSFWebHelper.findInitParam(webxml, data.param);
        if (p == null) {
            if (data.defaultList != null && data.defaultList[0].endsWith("/" + oldConfigName) && path != null) {
                JSFWebHelper.registerConfigFile(model, path, data);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        String[] cs = JSFWebHelper.getConfigFilesList(webxml, data);
        boolean done = false;
        int i = 0;
        while (i < cs.length) {
            String n;
            if (cs[i].endsWith("/" + oldConfigName) && (n = String.valueOf(cs[i].substring(0, cs[i].length() - oldConfigName.length())) + newConfigName).equals(path)) {
                cs[i] = n;
                done = true;
            }
            if (sb.length() > 0) {
                sb.append(data.separator.charAt(0));
            }
            sb.append(cs[i]);
            ++i;
        }
        if (!done && data.defaultList != null && data.defaultList[0].endsWith("/" + oldConfigName)) {
            if (sb.length() > 0) {
                sb.append(data.separator.charAt(0));
            }
            sb.append(path);
        }
        model.changeObjectAttribute(p, PARAM_VALUE, sb.toString());
        if (webxml != null) {
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)webxml, null);
        }
    }
}

