/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.DeleteFileHandler;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;

public class DeleteGroupHandler
extends AbstractHandler
implements JSFConstants {
    public boolean isEnabled(XModelObject object) {
        if (object == null || !object.isObjectEditable()) {
            return false;
        }
        if (!"JSFProcessGroup".equals(object.getModelEntity().getName())) {
            return false;
        }
        ReferenceGroupImpl g = (ReferenceGroupImpl)object;
        return g.getReferences().length > 0 || "true".equals(g.getAttributeValue("persistent"));
    }

    public boolean getSignificantFlag(XModelObject object) {
        return this.getPage(object) == null;
    }

    private XModelObject getPage(XModelObject object) {
        if (object == null) {
            return null;
        }
        String path = object.getAttributeValue("path");
        return path == null || path.length() == 0 ? null : object.getModel().getByPath(path);
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        Boolean pb;
        if (!this.isEnabled(object)) {
            return;
        }
        ReferenceGroupImpl g = (ReferenceGroupImpl)object;
        XModelObject page = this.getPage(object);
        boolean deletePage = page != null;
        Boolean bl = pb = p == null ? null : (Boolean)p.get("deletePage");
        if (pb != null) {
            deletePage = deletePage && pb != false;
        } else if (deletePage) {
            String message = MessageFormat.format(JSFUIMessages.DeleteGroupHandler_Delete, DefaultCreateHandler.title((XModelObject)object, (boolean)false));
            int q = this.confirmPageDelete(object.getModel(), message);
            if (q < 0) {
                return;
            }
            boolean bl2 = deletePage = q == 0;
            if (p != null) {
                p.put("deletePage", (Object)(q == 0 ? 1 : 0));
            }
        }
        g.getModel().changeObjectAttribute((XModelObject)g, "persistent", "false");
        XModelObject[] cs = g.getReferences();
        int i = cs.length - 1;
        while (i >= 0) {
            DefaultRemoveHandler.removeFromParent((XModelObject)cs[i]);
            --i;
        }
        if (cs.length == 0) {
            JSFProcessHelper.getHelper(object.getParent()).updateProcess();
        }
        if (deletePage) {
            new DeleteFileHandler().executeHandler(page, null);
        }
    }

    private int confirmPageDelete(XModel model, String message) {
        ServiceDialog d = model.getService();
        Properties dp = new Properties();
        dp.setProperty("message", message);
        dp.put("checked", Boolean.FALSE);
        dp.setProperty("checkboxMessage", JSFUIMessages.DeleteGroupHandler_DeleteFileFromDisk);
        if (!d.openConfirm(dp)) {
            return -1;
        }
        Boolean b = (Boolean)dp.get("checked");
        return b != null && b != false ? 0 : 1;
    }
}

