/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.el.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.IRelevanceCheck;
import org.jboss.tools.jst.web.kb.refactoring.RefactorSearcher;

public abstract class ELRenameProcessor
extends RenameProcessor {
    protected static final String JAVA_EXT = "java";
    protected static final String XML_EXT = "xml";
    protected static final String XHTML_EXT = "xhtml";
    protected static final String JSP_EXT = "jsp";
    protected static final String PROPERTIES_EXT = "properties";
    protected static final RefactoringParticipant[] EMPTY_REF_PARTICIPANT = new RefactoringParticipant[0];
    protected static final String SEAM_PROPERTIES_FILE = "seam.properties";
    protected RefactoringStatus status;
    protected CompositeChange rootChange;
    protected TextFileChange lastChange;
    protected IFile declarationFile = null;
    private ArrayList<String> keys = new ArrayList();
    private String newName;
    private String oldName;
    private ELSearcher searcher = null;

    public ELRenameProcessor(IFile file, String oldName) {
        this.searcher = new ELSearcher(file, oldName);
    }

    protected RefactorSearcher getSearcher() {
        return this.searcher;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    protected String getNewName() {
        return this.newName;
    }

    protected void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = new TextFileChange(file.getName(), file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    public class ELSearcher
    extends RefactorSearcher {
        ArrayList<String> keys;

        public ELSearcher(IFile file, String oldName) {
            super(file, oldName);
            this.keys = new ArrayList();
        }

        public void setJavaElement(IJavaElement javaElement) {
            this.javaElement = javaElement;
        }

        protected IProject[] getProjects() {
            return new IProject[]{this.baseFile.getProject()};
        }

        protected IRelevanceCheck[] getRelevanceChecks(ELResolver[] resolvers) {
            if (resolvers == null) {
                return new IRelevanceCheck[0];
            }
            IRelevanceCheck[] result = new IRelevanceCheck[resolvers.length];
            IRelevanceCheck check = new IRelevanceCheck(){

                public boolean isRelevant(String content) {
                    if (content == null) {
                        return true;
                    }
                    return content.indexOf(ELRenameProcessor.this.oldName) >= 0;
                }
            };
            int i = 0;
            while (i < result.length) {
                result[i] = check;
                ++i;
            }
            return result;
        }

        protected void match(IFile file, int offset, int length) {
            if (this.isFileReadOnly(file)) {
                ELRenameProcessor.this.status.addFatalError(NLS.bind((String)ElCoreMessages.EL_RENAME_PROCESSOR_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
            } else {
                ELRenameProcessor.this.change(file, offset, length, ELRenameProcessor.this.newName);
            }
        }

        protected void outOfSynch(IResource resource) {
            ELRenameProcessor.this.status.addWarning(NLS.bind((String)ElCoreMessages.EL_RENAME_PROCESSOR_OUT_OF_SYNC_PROJECT, (Object)resource.getFullPath().toString()));
        }

        protected ELInvocationExpression findComponentReference(ELInvocationExpression invocationExpression) {
            ELInvocationExpression invExp = invocationExpression;
            while (invExp != null) {
                if (invExp instanceof ELPropertyInvocation) {
                    if (((ELPropertyInvocation)invExp).getQualifiedName() != null && ((ELPropertyInvocation)invExp).getQualifiedName().equals(this.propertyName)) {
                        return invExp;
                    }
                    invExp = invExp.getLeft();
                    continue;
                }
                invExp = invExp.getLeft();
            }
            return null;
        }
    }
}

