/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.registry;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.internal.util.BundleHttpCacheStorage;
import org.eclipse.thym.core.internal.util.HttpUtil;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginVersion;
import org.eclipse.thym.core.plugin.registry.PluginReceiver;

public class CordovaPluginRegistryManager {
    private static final String REGISTRY_CLIENT_ID = "eclipseTHyM";
    public static final String DEFAULT_REGISTRY_URL = "http://registry.cordova.io/";
    private String registry;
    private final File cacheHome;
    private HashMap<String, CordovaRegistryPlugin> detailedPluginInfoCache = new HashMap();

    public CordovaPluginRegistryManager(String url) {
        this.registry = url;
        this.cacheHome = new File(FileUtils.getUserDirectory(), ".plugman" + File.separator + "cache");
    }

    public CordovaRegistryPlugin getCordovaPluginInfo(String name) throws CoreException {
        CordovaRegistryPlugin plugin = this.detailedPluginInfoCache.get(name);
        if (plugin != null) {
            return plugin;
        }
        DefaultHttpClient defHttpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(defHttpClient);
        CachingHttpClient client = new CachingHttpClient((HttpClient)defHttpClient, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()), CordovaPluginRegistryManager.getCacheConfig());
        String url = this.registry.endsWith("/") ? String.valueOf(this.registry) + name : String.valueOf(this.registry) + "/" + name;
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
            plugin = new CordovaRegistryPlugin();
            this.readPluginInfo(reader, plugin);
            this.detailedPluginInfoCache.put(name, plugin);
            return plugin;
        }
        catch (ClientProtocolException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin information for " + name, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin information for " + name, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInstallationDirectory(CordovaRegistryPluginVersion plugin, IProgressMonitor monitor) {
        File pluginDir;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pluginDir = this.getFromCache(plugin)) != null) {
            return pluginDir;
        }
        File newCacheDir = this.calculateCacheDir(plugin);
        IRetrieveFileTransfer transfer = HybridCore.getDefault().getFileTransferService();
        try {
            IFileID remoteFileID = FileIDFactory.getDefault().createFileID(transfer.getRetrieveNamespace(), plugin.getDistributionTarball());
            Object lock = new Object();
            PluginReceiver receiver = new PluginReceiver(newCacheDir, monitor, lock);
            Object object = lock;
            synchronized (object) {
                transfer.sendRetrieveRequest(remoteFileID, (IFileTransferListener)receiver, null);
                lock.wait();
            }
        }
        catch (FileCreateException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        catch (IncomingFileTransferException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        catch (InterruptedException e) {
            HybridCore.log(4, "Cordova plugin fetch error", e);
        }
        this.updateDownlodCounter(plugin.getName());
        return new File(newCacheDir, "package");
    }

    private void updateDownlodCounter(String pluginId) {
        if (!this.registry.contains("registry.cordova.io")) {
            return;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpUtil.setupProxy(client);
        String url = this.registry.endsWith("/") ? String.valueOf(this.registry) + "downloads" : String.valueOf(this.registry) + "/downloads";
        HttpPost post = new HttpPost(url);
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM.dd");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        JsonObject obj = new JsonObject();
        obj.addProperty("day", df.format(now));
        obj.addProperty("pkg", pluginId);
        obj.addProperty("client", REGISTRY_CLIENT_ID);
        Gson gson = new Gson();
        String json = gson.toJson((JsonElement)obj);
        try {
            StringEntity entity = new StringEntity(json);
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 201) {
                HybridCore.log(1, "Unable to ping Cordova registry download counter", null);
            }
        }
        catch (UnsupportedEncodingException e) {
            HybridCore.log(1, "Unable to ping Cordova registry download counter", e);
        }
        catch (IOException e) {
            HybridCore.log(1, "Unable to ping Cordova registry download counter", e);
        }
    }

    private File getFromCache(CordovaRegistryPluginVersion plugin) {
        File cachedPluginDir = this.calculateCacheDir(plugin);
        File packageDir = new File(cachedPluginDir, "package");
        if (!packageDir.isDirectory()) {
            return null;
        }
        File pluginxml = new File(packageDir, "plugin.xml");
        if (cachedPluginDir.isDirectory() && pluginxml.exists()) {
            return packageDir;
        }
        return null;
    }

    private File calculateCacheDir(CordovaRegistryPluginVersion plugin) {
        File cachedPluginDir = new File(this.cacheHome, String.valueOf(plugin.getName()) + File.separator + plugin.getVersionNumber());
        return cachedPluginDir;
    }

    private static CacheConfig getCacheConfig() {
        CacheConfig config = new CacheConfig();
        config.setMaxObjectSize(122880L);
        return config;
    }

    public List<CordovaRegistryPluginInfo> retrievePluginInfos(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Retrieve plug-in registry catalog", 10);
        DefaultHttpClient theHttpClient = new DefaultHttpClient();
        HttpUtil.setupProxy(theHttpClient);
        CachingHttpClient client = new CachingHttpClient((HttpClient)theHttpClient, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BundleHttpCacheStorage(HybridCore.getContext().getBundle()), CordovaPluginRegistryManager.getCacheConfig());
        String url = this.registry.endsWith("/") ? String.valueOf(this.registry) + "-/all" : String.valueOf(this.registry) + "/-/all";
        HttpGet get = new HttpGet(url);
        try {
            if (monitor.isCanceled()) {
                return null;
            }
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            InputStream stream = entity.getContent();
            monitor.worked(7);
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
            reader.beginObject();
            ArrayList<CordovaRegistryPluginInfo> plugins = new ArrayList<CordovaRegistryPluginInfo>();
            block11: while (reader.hasNext()) {
                JsonToken token = reader.peek();
                switch (token) {
                    case BEGIN_OBJECT: {
                        CordovaRegistryPluginInfo info = new CordovaRegistryPluginInfo();
                        this.readPluginInfo(reader, info);
                        plugins.add(info);
                        break;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (!name.equals("_updated")) continue block11;
                        reader.nextLong();
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)("Unexpected token: " + token));
                    }
                }
            }
            reader.endObject();
            ArrayList<CordovaRegistryPluginInfo> arrayList = plugins;
            return arrayList;
        }
        catch (ClientProtocolException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin catalog", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Can not retrieve plugin catalog", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void readPluginInfo(JsonReader reader, CordovaRegistryPluginInfo plugin) throws IOException {
        Assert.isNotNull((Object)plugin);
        reader.beginObject();
        block3: while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case NAME: {
                    String name = reader.nextName();
                    if ("name".equals(name)) {
                        plugin.setName(reader.nextString());
                        break;
                    }
                    if ("description".equals(name)) {
                        plugin.setDescription(reader.nextString());
                        break;
                    }
                    if ("keywords".equals(name)) {
                        this.parseKeywords(reader, plugin);
                        break;
                    }
                    if ("maintainers".equals(name)) {
                        this.parseMaintainers(reader, plugin);
                        break;
                    }
                    if ("dist-tags".equals(name)) {
                        this.parseLatestVersion(reader, plugin);
                        break;
                    }
                    if ("versions".equals(name) && plugin instanceof CordovaRegistryPlugin) {
                        this.parseDetailedVersions(reader, (CordovaRegistryPlugin)plugin);
                        break;
                    }
                    if ("dist".equals(name) && plugin instanceof CordovaRegistryPluginVersion) {
                        this.parseDistDetails(reader, (CordovaRegistryPluginVersion)plugin);
                        break;
                    }
                    if (!"license".equals(name) || !(plugin instanceof CordovaRegistryPluginVersion)) continue block3;
                    CordovaRegistryPluginVersion v = (CordovaRegistryPluginVersion)plugin;
                    v.setLicense(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
    }

    private void parseDistDetails(JsonReader reader, CordovaRegistryPluginVersion plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    String name = reader.nextName();
                    if ("shasum".equals(name)) {
                        plugin.setDistributionSHASum(reader.nextString());
                        break;
                    }
                    if (!"tarball".equals(name)) break;
                    plugin.setDistributionTarball(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseDetailedVersions(JsonReader reader, CordovaRegistryPlugin plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    CordovaRegistryPluginVersion version = new CordovaRegistryPluginVersion();
                    version.setVersionNumber(reader.nextName());
                    this.readPluginInfo(reader, version);
                    plugin.addVersion(version);
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseLatestVersion(JsonReader reader, CordovaRegistryPluginInfo plugin) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (token != JsonToken.END_OBJECT) {
            switch (token) {
                case NAME: {
                    String tag = reader.nextName();
                    if (!"latest".equals(tag)) break;
                    plugin.setLatestVersion(reader.nextString());
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
            token = reader.peek();
        }
        reader.endObject();
    }

    private void parseMaintainers(JsonReader reader, CordovaRegistryPluginInfo plugin) throws IOException {
        reader.beginArray();
        String name = null;
        String email = null;
        JsonToken token = reader.peek();
        while (token != JsonToken.END_ARRAY) {
            switch (token) {
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    email = null;
                    name = null;
                    break;
                }
                case END_OBJECT: {
                    reader.endObject();
                    plugin.addMaintainer(email, name);
                    break;
                }
                case NAME: {
                    String tagName = reader.nextName();
                    if ("name".equals(tagName)) {
                        name = reader.nextString();
                        break;
                    }
                    if ("email".equals(tagName)) {
                        email = reader.nextString();
                        break;
                    }
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unexpected token");
                }
            }
            token = reader.peek();
        }
        reader.endArray();
    }

    private void parseKeywords(JsonReader reader, CordovaRegistryPluginInfo plugin) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            plugin.addKeyword(reader.nextString());
        }
        reader.endArray();
    }
}

