/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.eclipse.thym.core.internal.util.TarEntry;
import org.eclipse.thym.core.internal.util.TarException;
import org.eclipse.thym.core.internal.util.TarInputStream;

public class TarFile {
    private File file;
    private TarInputStream entryEnumerationStream;
    private TarEntry curEntry;
    private TarInputStream entryStream;
    private InputStream internalEntryStream;

    public TarFile(File file) throws TarException, IOException {
        this.file = file;
        InputStream in = new FileInputStream(file);
        try {
            in = new GZIPInputStream(in);
        }
        catch (IOException iOException) {
            in.close();
            in = new FileInputStream(file);
        }
        try {
            this.entryEnumerationStream = new TarInputStream(in);
        }
        catch (TarException ex) {
            in.close();
            throw ex;
        }
        this.curEntry = this.entryEnumerationStream.getNextEntry();
    }

    public void close() throws IOException {
        if (this.entryEnumerationStream != null) {
            this.entryEnumerationStream.close();
        }
        if (this.internalEntryStream != null) {
            this.internalEntryStream.close();
        }
    }

    public TarFile(String filename) throws TarException, IOException {
        this(new File(filename));
    }

    public Enumeration<TarEntry> entries() {
        return new Enumeration<TarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return TarFile.this.curEntry != null;
            }

            @Override
            public TarEntry nextElement() {
                TarEntry oldEntry = TarFile.this.curEntry;
                try {
                    TarFile.this.curEntry = TarFile.this.entryEnumerationStream.getNextEntry();
                }
                catch (TarException tarException) {
                    TarFile.this.curEntry = null;
                }
                catch (IOException iOException) {
                    TarFile.this.curEntry = null;
                }
                return oldEntry;
            }
        };
    }

    public InputStream getInputStream(TarEntry entry) throws TarException, IOException {
        if (this.entryStream == null || !this.entryStream.skipToEntry(entry)) {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
            this.internalEntryStream = new FileInputStream(this.file);
            try {
                this.internalEntryStream = new GZIPInputStream(this.internalEntryStream);
            }
            catch (IOException iOException) {
                this.internalEntryStream.close();
                this.internalEntryStream = new FileInputStream(this.file);
            }
            this.entryStream = new TarInputStream(this.internalEntryStream, entry){

                @Override
                public void close() {
                }
            };
        }
        return this.entryStream;
    }

    public String getName() {
        return this.file.getPath();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

