/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;

public class BaseListFieldEditor
extends BaseFieldEditor {
    private ListViewer viewer = null;
    private ActionPanel actionPanel;

    public BaseListFieldEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        Composite root = (Composite)composite;
        this.createLabelControl(root);
        this.createListView(root);
        this.createActionBar(root);
        return new Control[]{this.getLabelControl(), this.viewer.getControl(), this.actionPanel};
    }

    protected void createListView(Composite parent) {
        this.viewer = new ListViewer(parent, 68098);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return inputElement instanceof List ? ((List)inputElement).toArray() : new Object[]{};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.viewer.setInput(this.getValue());
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    protected void createActionBar(Composite parent) {
        this.actionPanel = new ActionPanel(parent, new BaseAction[]{new AddAction(), new RemoveAction()});
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.actionPanel);
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.getLabelControl(), this.viewer.getControl(), this.actionPanel};
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    @Override
    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)"Error_Basic_Editor_Composite");
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)"Error_JBoss_Basic_Editor_Support");
        Composite aComposite = (Composite)parent;
        this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 1;
        this.getLabelControl().setLayoutData((Object)gdLabel);
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns - 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        ((Control)this.getEditorControls()[1]).setLayoutData((Object)gd);
        GridData dgAction = new GridData();
        dgAction.horizontalSpan = 1;
        dgAction.verticalAlignment = 4;
        ((Control)this.getEditorControls()[2]).setLayoutData((Object)dgAction);
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected List<Object> runAddAction() {
        return new ArrayList<Object>();
    }

    public class ActionButton
    implements IPropertyChangeListener {
        private Button button;
        private BaseAction action;

        public ActionButton(Composite parent, int style, BaseAction action) {
            this.button = new Button(parent, style);
            this.action = action;
            GridData gd = new GridData(768, 1, false, false);
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            gd.widthHint = BaseListFieldEditor.this.convertHorizontalDLUsToPixels((Control)this.button, 61);
            this.button.setLayoutData((Object)gd);
            this.action.addPropertyChangeListener(this);
            this.button.setText(action.getText());
            this.button.setEnabled(action.isEnabled());
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ActionButton.this.action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Control getControl() {
            return this.button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public class ActionPanel
    extends Composite
    implements ISelectionChangedListener {
        private BaseAction[] actions;

        public ActionPanel(Composite parent, int style, BaseAction[] actions) {
            super(parent, style);
            this.actions = null;
            this.actions = actions;
            this.setLayout((Layout)new GridLayout(1, false));
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                new ActionButton(this, 8, action);
                ++n2;
            }
        }

        public ActionPanel(Composite parent, BaseAction[] actions) {
            this(parent, 0, actions);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                action.setSelection(event.getSelection());
                ++n2;
            }
        }
    }

    public class AddAction
    extends BaseAction {
        public AddAction() {
            super(CommonUIMessages.BUTTON_ADD);
            this.setEnabled(true);
        }

        @Override
        protected void updateEnablement() {
        }

        public void run() {
            List current = (List)BaseListFieldEditor.this.getValue();
            List<Object> added = BaseListFieldEditor.this.runAddAction();
            added.removeAll(current);
            if (!added.isEmpty()) {
                added.addAll(current);
                BaseListFieldEditor.this.setValue(added);
                BaseListFieldEditor.this.viewer.setInput(BaseListFieldEditor.this.getValue());
                BaseListFieldEditor.this.viewer.refresh();
            }
        }
    }

    public static abstract class BaseAction
    extends Action {
        Object[] objects = new Object[0];

        public BaseAction(String name) {
            super(name);
            this.updateEnablement();
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                ArrayList<Object> rts = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object rt = objectArray[n2];
                    rts.add(rt);
                    ++n2;
                }
                this.objects = rts.toArray(new Object[0]);
            } else {
                this.objects = new Object[0];
            }
            this.updateEnablement();
        }

        protected abstract void updateEnablement();
    }

    public class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(CommonUIMessages.BUTTON_REMOVE);
        }

        @Override
        protected void updateEnablement() {
            this.setEnabled(this.objects.length > 0);
        }

        public void run() {
            List current = (List)BaseListFieldEditor.this.getValue();
            ArrayList changed = new ArrayList();
            changed.addAll(current);
            Object[] objectArray = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object rt = objectArray[n2];
                changed.remove(rt);
                ++n2;
            }
            if (changed.size() != current.size()) {
                BaseListFieldEditor.this.setValue(changed);
            }
            BaseListFieldEditor.this.viewer.setInput(BaseListFieldEditor.this.getValue());
            BaseListFieldEditor.this.viewer.refresh();
        }
    }
}

