/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.controls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.extensions.IAttributeControlFactory;
import org.jboss.tools.jmx.ui.extensions.IWritableAttributeHandler;
import org.jboss.tools.jmx.ui.internal.controls.ArrayControlFactory;
import org.jboss.tools.jmx.ui.internal.controls.TextControlFactory;

public class AttributeControlFactory {
    private static final Map<String, List<IAttributeControlFactory>> typeFactories;
    private static final Map<String, Map<Pattern, IAttributeControlFactory>> patternFactories;
    private static final IAttributeControlFactory defaultFactory;
    private static final IAttributeControlFactory arrayFactory;

    static {
        IAttributeControlFactory factory;
        defaultFactory = new TextControlFactory();
        arrayFactory = new ArrayControlFactory();
        HashMap<String, ArrayList<IAttributeControlFactory>> typeMap = new HashMap<String, ArrayList<IAttributeControlFactory>>();
        HashMap<String, IAttributeControlFactory> idMap = new HashMap<String, IAttributeControlFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint epDisplays = registry.getExtensionPoint("org.jboss.tools.jmx.ui.attribute.controls");
        IConfigurationElement[] iConfigurationElementArray = epDisplays.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute("id");
                String type = element.getAttribute("type");
                factory = null;
                try {
                    factory = (IAttributeControlFactory)element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    break block7;
                }
                if (factory != null) {
                    ArrayList<IAttributeControlFactory> displays = (ArrayList<IAttributeControlFactory>)typeMap.get(type);
                    if (displays == null) {
                        displays = new ArrayList<IAttributeControlFactory>(1);
                        typeMap.put(type, displays);
                    }
                    displays.add(factory);
                }
                idMap.put(id, factory);
            }
            ++n2;
        }
        HashMap<String, HashMap<Pattern, IAttributeControlFactory>> patternMap = new HashMap<String, HashMap<Pattern, IAttributeControlFactory>>();
        IExtensionPoint bindings = registry.getExtensionPoint("org.jboss.tools.jmx.ui.attribute.bindings");
        IConfigurationElement[] iConfigurationElementArray2 = bindings.getConfigurationElements();
        int n3 = iConfigurationElementArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement element = iConfigurationElementArray2[n4];
            factory = (IAttributeControlFactory)idMap.get(element.getAttribute("controlID"));
            String name = element.getAttribute("name");
            Pattern pattern = Pattern.compile(element.getAttribute("objectName"));
            HashMap<Pattern, IAttributeControlFactory> factoryMap = (HashMap<Pattern, IAttributeControlFactory>)patternMap.get(name);
            if (factoryMap == null) {
                factoryMap = new HashMap<Pattern, IAttributeControlFactory>();
                patternMap.put(name, factoryMap);
            }
            factoryMap.put(pattern, factory);
            ++n4;
        }
        typeFactories = Collections.unmodifiableMap(typeMap);
        patternFactories = Collections.unmodifiableMap(patternMap);
    }

    public static Control createControl(Composite parent, Object value) {
        if (value == null) {
            return null;
        }
        return AttributeControlFactory.createControl(parent, value, value.getClass().getSimpleName(), null, null, false, null, null);
    }

    public static Control createControl(Composite parent, Object value, String type, String objectName, String attributeName, boolean writable, IWritableAttributeHandler handler, FormToolkit toolkit) {
        Map<Pattern, IAttributeControlFactory> patterns;
        IAttributeControlFactory factory = null;
        if (objectName != null && attributeName != null && (patterns = patternFactories.get(attributeName)) != null) {
            for (Map.Entry<Pattern, IAttributeControlFactory> entry : patterns.entrySet()) {
                if (!entry.getKey().matcher(objectName).matches()) continue;
                factory = entry.getValue();
            }
        }
        if (factory == null) {
            List<IAttributeControlFactory> factories;
            Class<Object> clazz;
            Class<Object> clazz2 = clazz = value == null ? AttributeControlFactory.getClass(type) : value.getClass();
            factory = clazz == null ? defaultFactory : ((factories = AttributeControlFactory.findFactories(clazz)) == null ? (value.getClass().isArray() ? arrayFactory : defaultFactory) : factories.get(0));
        }
        return factory.createControl(parent, toolkit, writable, type, value, handler);
    }

    private static List<IAttributeControlFactory> findFactories(Class<? extends Object> valueClass) {
        for (Map.Entry<String, List<IAttributeControlFactory>> entry : typeFactories.entrySet()) {
            try {
                if (!Class.forName(entry.getKey()).isAssignableFrom(valueClass)) continue;
                return entry.getValue();
            }
            catch (ClassNotFoundException e) {
                JMXUIActivator.log(2, e.getMessage(), e);
            }
        }
        return null;
    }

    private static Class<? extends Object> getClass(String type) {
        Class result = null;
        if (type.equals("int")) {
            result = Integer.class;
        } else if (type.equals("boolean")) {
            result = Boolean.class;
        } else if (type.equals("short")) {
            result = Short.class;
        } else if (type.equals("long")) {
            result = Long.class;
        } else if (type.equals("char")) {
            result = Character.class;
        } else if (type.equals("byte")) {
            result = Byte.class;
        } else if (type.equals("float")) {
            result = Float.class;
        } else {
            try {
                result = Class.forName(type);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }
}

