/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.OpenShiftException;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.ISSHKeyWizardPageModel;

public abstract class AbstractSSHKeyWizardPageModel
extends ObservableUIPojo
implements ISSHKeyWizardPageModel {
    private String name;
    private Connection connection;

    AbstractSSHKeyWizardPageModel(Connection user) {
        this.connection = user;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public boolean hasKeyName(String name) {
        return this.connection.hasSSHKeyName(name);
    }

    @Override
    public boolean hasPublicKey(String publicKeyContent) {
        return this.connection.hasSSHPublicKey(publicKeyContent);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected String checkedGetSSH2Home() throws OpenShiftException {
        String ssh2Home = SSHUtils.getSSH2Home();
        if (ssh2Home == null || ssh2Home.trim().length() == 0) {
            throw new OpenShiftException("Could not determine your ssh2 home directory", new Object[0]);
        }
        return ssh2Home;
    }
}

