/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.snapshot;

import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.util.FileUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.snapshot.SaveSnapshotWizardModel;

public class SaveSnapshotWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_FILEPATH = "filepath";
    public static final String PROPERTY_DEPLOYMENT_SNAPSHOT = "deploymentSnapshot";
    private SaveSnapshotWizardModel wizardModel;
    private String directory;

    public SaveSnapshotWizardPageModel(SaveSnapshotWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        String filepath = wizardModel.getFilepath();
        if (filepath != null) {
            this.directory = StringUtils.left((String)filepath, (int)(filepath.length() - FilenameUtils.getName((String)filepath).length()));
        }
    }

    public void setFilepath(String filepath) {
        this.firePropertyChange(PROPERTY_FILEPATH, this.wizardModel.getFilepath(), this.wizardModel.setFilepath(filepath));
    }

    public String getFilepath() {
        return this.wizardModel.getFilepath();
    }

    public String getDestination() {
        return this.directory;
    }

    public void setDestination(String directory) {
        this.directory = directory;
        String filepath = this.getFilePath(directory, this.wizardModel.getApplication().getName(), this.getSnapshotTypeString(this.isDeploymentSnapshot()));
        this.setFilepath(filepath);
    }

    private String getFilePath(String directory, String applicationName, String snapshotType) {
        String snashotFilename = MessageFormat.format("{0}-{1}.tar.gz", applicationName, snapshotType);
        File destinationFile = new File(directory, snashotFilename);
        String filepath = FileUtils.getAvailableFilepath((String)destinationFile.getAbsolutePath());
        return filepath;
    }

    public void setProject(IProject project) {
        if (project == null) {
            return;
        }
        this.wizardModel.setProject(project);
        this.setDestination(project.getLocation().toString());
    }

    private String getSnapshotTypeString(boolean deploymentSnapshot) {
        if (deploymentSnapshot) {
            return "deployment";
        }
        return "full";
    }

    public void setDeploymentSnapshot(boolean deploymentSnapshot) {
        this.firePropertyChange(PROPERTY_DEPLOYMENT_SNAPSHOT, this.wizardModel.isDeploymentSnapshot(), this.wizardModel.setDeploymentSnapshot(deploymentSnapshot));
        if (this.directory != null) {
            String filepath = this.getFilePath(this.directory, this.wizardModel.getApplication().getName(), this.getSnapshotTypeString(deploymentSnapshot));
            this.setFilepath(filepath);
        }
    }

    public boolean isDeploymentSnapshot() {
        return this.wizardModel.isDeploymentSnapshot();
    }
}

