/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;
import org.jboss.tools.openshift.express.internal.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.AbstractEnvironmentVariablesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableWizard;

public class EnvironmentVariablesWizardPage
extends AbstractOpenShiftWizardPage {
    private AbstractEnvironmentVariablesWizardModel model;
    private TableViewer viewer;

    public EnvironmentVariablesWizardPage(AbstractEnvironmentVariablesWizardModel model, IWizard wizard) {
        super(OpenshiftUIMessages.EnvironmentVariables, OpenshiftUIMessages.PleaseProvadeNewVariable, "", wizard);
        this.model = model;
    }

    @Override
    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(container);
        Group envVariableGroup = new Group(container, 0);
        envVariableGroup.setText(OpenshiftUIMessages.EnvironmentVariables);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)envVariableGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)envVariableGroup);
        Composite tableContainer = new Composite((Composite)envVariableGroup, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(BeanProperties.value((String)"selected").observe((Object)this.model)).in(dbc);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setInput((Object)BeanProperties.list((String)"variables").observe((Object)this.model));
        Button addButton = new Button((Composite)envVariableGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)addButton);
        addButton.setText(OpenshiftUIMessages.Add);
        addButton.addSelectionListener(this.onAdd());
        Button editExistingButton = new Button((Composite)envVariableGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editExistingButton);
        editExistingButton.setText(OpenshiftUIMessages.Edit);
        editExistingButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selected").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button removeButton = new Button((Composite)envVariableGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText(OpenshiftUIMessages.Remove);
        removeButton.addSelectionListener(this.onRemove());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selected").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Label filler = new Label((Composite)envVariableGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, true).applyTo((Control)filler);
        Button refreshButton = new Button((Composite)envVariableGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)refreshButton);
        refreshButton.setText(OpenshiftUIMessages.Refresh);
        refreshButton.addSelectionListener(this.onRefresh());
        this.enableEnvVariableGroup(this.model.isSupported(), envVariableGroup);
        Label validationLabel = new Label((Composite)envVariableGroup, 0);
        validationLabel.setVisible(false);
        GridDataFactory.fillDefaults().exclude(true).applyTo((Control)validationLabel);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)validationLabel)).notUpdating(BeanProperties.value((String)"supported").observe((Object)this.model)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (Boolean.FALSE.equals((Boolean)value)) {
                    return ValidationStatus.warning((String)NLS.bind((String)OpenshiftUIMessages.ServerDoesNotSupportChanging, (Object)EnvironmentVariablesWizardPage.this.model.getHost()));
                }
                return ValidationStatus.ok();
            }
        })).in(dbc);
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column(new TableViewerBuilder.IColumnLabelProvider<EnvironmentVariableItem>(){

            @Override
            public String getValue(EnvironmentVariableItem variable) {
                return variable.getName();
            }
        }).name("Name").align(16384).weight(2).minWidth(100).buildColumn().column(new TableViewerBuilder.IColumnLabelProvider<EnvironmentVariableItem>(){

            @Override
            public String getValue(EnvironmentVariableItem variable) {
                return variable.getValue();
            }
        }).name("Value").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        return this.viewer;
    }

    private void enableEnvVariableGroup(final boolean enable, Group envVariableGroup) {
        envVariableGroup.setEnabled(enable);
        UIUtils.doForAllChildren(new UIUtils.IWidgetVisitor(){

            @Override
            public void visit(Control control) {
                control.setEnabled(enable);
            }
        }, (Composite)envVariableGroup);
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new LoadEnvironmentVariablesJob(), (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InvocationTargetException e) {
            Logger.error(OpenshiftUIMessages.CouldNotLoadVariables, e);
        }
        catch (InterruptedException e) {
            Logger.error(OpenshiftUIMessages.CouldNotLoadVariables, e);
        }
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentVariableWizard wizard = new EnvironmentVariableWizard(EnvironmentVariablesWizardPage.this.model);
                new OkCancelButtonWizardDialog(EnvironmentVariablesWizardPage.this.getShell(), (IWizard)wizard).open();
            }
        };
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OkCancelButtonWizardDialog editVariableWizardDialog = new OkCancelButtonWizardDialog(EnvironmentVariablesWizardPage.this.getShell(), (IWizard)new EnvironmentVariableWizard(EnvironmentVariablesWizardPage.this.model.getSelected(), EnvironmentVariablesWizardPage.this.model));
                editVariableWizardDialog.open();
                EnvironmentVariablesWizardPage.this.viewer.refresh();
            }
        };
    }

    private SelectionListener onRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVariableItem selectedVariable = EnvironmentVariablesWizardPage.this.model.getSelected();
                if (selectedVariable == null) {
                    return;
                }
                if (MessageDialog.openConfirm((Shell)EnvironmentVariablesWizardPage.this.getShell(), (String)OpenshiftUIMessages.RemoveVariable, (String)NLS.bind((String)OpenshiftUIMessages.DoYouWantToRemoveVariable, (Object)(String.valueOf(selectedVariable.getName()) + "=" + selectedVariable.getValue())))) {
                    EnvironmentVariablesWizardPage.this.model.remove(selectedVariable);
                }
            }
        };
    }

    private SelectionListener onRefresh() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (MessageDialog.openConfirm((Shell)EnvironmentVariablesWizardPage.this.getShell(), (String)OpenshiftUIMessages.RefreshVariables, (String)OpenshiftUIMessages.DoYouWantToRefreshVariables)) {
                        WizardUtils.runInWizard((Job)new RefreshEnvironmentVariablesJob(), (IWizardContainer)EnvironmentVariablesWizardPage.this.getContainer(), (DataBindingContext)EnvironmentVariablesWizardPage.this.getDatabindingContext());
                    }
                }
                catch (InvocationTargetException e) {
                    Logger.error(OpenshiftUIMessages.CouldNotRefreshVariables, e);
                }
                catch (InterruptedException e) {
                    Logger.error(OpenshiftUIMessages.CouldNotRefreshVariables, e);
                }
            }
        };
    }

    private class LoadEnvironmentVariablesJob
    extends AbstractDelegatingMonitorJob {
        public LoadEnvironmentVariablesJob() {
            super(OpenshiftUIMessages.LoadingVariables);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            EnvironmentVariablesWizardPage.this.model.loadEnvironmentVariables();
            return Status.OK_STATUS;
        }
    }

    private class RefreshEnvironmentVariablesJob
    extends AbstractDelegatingMonitorJob {
        public RefreshEnvironmentVariablesJob() {
            super(OpenshiftUIMessages.RefreshingVariables);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            EnvironmentVariablesWizardPage.this.model.refreshEnvironmentVariables();
            return Status.OK_STATUS;
        }
    }
}

