/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIException;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;

public abstract class AbstractEnvironmentVariablesWizardModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_VARIABLES = "variables";
    public static final String PROPERTY_SUPPORTED = "supported";
    private List<EnvironmentVariableItem> variables = new ArrayList<EnvironmentVariableItem>();
    private EnvironmentVariableItem selected;

    public abstract void refreshEnvironmentVariables();

    public abstract void loadEnvironmentVariables();

    public List<EnvironmentVariableItem> getVariables() {
        return this.variables;
    }

    public EnvironmentVariableItem getSelected() {
        return this.selected;
    }

    public void setSelected(EnvironmentVariableItem variable) {
        this.selected = variable;
        this.firePropertyChange(PROPERTY_SELECTED, this.selected, this.selected);
    }

    public void add(EnvironmentVariableItem variable) {
        if (this.variables.contains(variable)) {
            throw new OpenShiftUIException("Cannot add a variable that already exists", new Object[0]);
        }
        this.variables.add(variable);
        this.firePropertyChange(PROPERTY_VARIABLES, null, this.variables);
    }

    protected void remove(EnvironmentVariableItem variable) {
        this.variables.remove(variable);
        this.firePropertyChange(PROPERTY_VARIABLES, null, this.variables);
    }

    public boolean contains(EnvironmentVariableItem variable) {
        return this.variables.contains(variable);
    }

    public EnvironmentVariableItem getVariable(String name) {
        for (EnvironmentVariableItem variable : this.variables) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public boolean contains(String name) {
        return this.getVariable(name) != null;
    }

    public abstract boolean isSupported();

    public abstract String getHost();

    protected void clear() {
        this.variables.clear();
        this.firePropertyChange(PROPERTY_VARIABLES, null, this.variables);
    }
}

