/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftEndpointException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.client.cartridge.query.LatestVersionOf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.core.EmbedCartridgeStrategy;
import org.jboss.tools.openshift.express.internal.core.util.CartridgeToStringConverter;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.CreateApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.job.WaitForApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.wizard.CreationLogDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.LogEntryFactory;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.AbstractCheckEmbeddableCartridgeStrategy;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardPageModel;

public class FullfillRequirementsCheckStrategy
extends AbstractCheckEmbeddableCartridgeStrategy {
    private static final int RESULT_IGNORE = 2;
    private static final int RESULT_CANCEL = 0;
    private static final int RESULT_APPLY = 1;
    private EmbedCartridgeStrategy strategy;

    public FullfillRequirementsCheckStrategy(EmbeddedCartridgesWizardPageModel pageModel, IWizardPage wizardPage) {
        super(pageModel, wizardPage);
        this.strategy = this.createEmbedCartridgeStrategy(pageModel.getDomain());
    }

    private EmbedCartridgeStrategy createEmbedCartridgeStrategy(IDomain domain) {
        IOpenShiftConnection connection = domain.getUser().getConnection();
        EmbedCartridgeStrategy embedCartridgeStrategy = new EmbedCartridgeStrategy(new ArrayList(connection.getEmbeddableCartridges()), new ArrayList(connection.getStandaloneCartridges()), (Collection)domain.getApplications());
        return embedCartridgeStrategy;
    }

    @Override
    protected void add(ICartridge cartridge, CheckStateChangedEvent event) {
        try {
            EmbedCartridgeStrategy.ApplicationRequirement missingRequirement = this.strategy.getMissingRequirement(cartridge, (EmbedCartridgeStrategy.IApplicationProperties)this.getPageModel());
            if (missingRequirement != null && !this.shouldAddToInappropriateApplication(missingRequirement, cartridge, this.getPageModel())) {
                this.getPageModel().uncheckEmbeddedCartridge(cartridge);
                return;
            }
            EmbedCartridgeStrategy.EmbeddableCartridgeDiff additionalOperations = this.strategy.add(cartridge, this.getPageModel().getCheckedCartridges());
            if (additionalOperations.hasChanges()) {
                this.executeAdditionalOperations(true, cartridge, additionalOperations);
            }
        }
        catch (OpenShiftException e) {
            OpenShiftUIActivator.log("Could not process embeddable cartridges", e);
        }
    }

    @Override
    protected void remove(ICartridge cartridge, CheckStateChangedEvent event) {
        try {
            EmbedCartridgeStrategy.EmbeddableCartridgeDiff additionalOperations = this.strategy.remove(cartridge, this.getPageModel().getCheckedCartridges());
            if (additionalOperations.hasChanges()) {
                this.getPageModel().uncheckEmbeddedCartridge(cartridge);
                this.executeAdditionalOperations(false, cartridge, additionalOperations);
            } else if (this.getPageModel().isEmbedded(cartridge)) {
                this.executeRemove(cartridge);
            }
        }
        catch (OpenShiftException e) {
            OpenShiftUIActivator.log("Could not process embeddable cartridges", e);
        }
    }

    private boolean shouldAddToInappropriateApplication(EmbedCartridgeStrategy.ApplicationRequirement requirement, ICartridge cartridge, EmbedCartridgeStrategy.IApplicationProperties applicationProperties) throws OpenShiftException {
        String title = NLS.bind((String)"Inappropriate application {0}", (Object)applicationProperties.getApplicationName());
        String message = String.valueOf(requirement.getMessage(cartridge, applicationProperties)) + NLS.bind((String)"\n\nAdding may fail, are you sure that you want to add cartridge {0}?", (Object)cartridge.getName());
        switch (this.openQuestionDialog(title, message)) {
            default: {
                return false;
            }
            case 1: 
        }
        return true;
    }

    private void executeRemove(ICartridge cartridge) {
        if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)NLS.bind((String)"Remove cartridge {0}", (Object)cartridge.getName()), (String)NLS.bind((String)"You are about to remove cartridge {0}.\nRemoving a cartridge is not reversible and can cause you to loose the data you have stored in it.\nAre you sure?", (Object)cartridge.getName()))) {
            this.getPageModel().checkEmbeddedCartridge(cartridge);
        }
    }

    private void executeAdditionalOperations(boolean add, ICartridge cartridge, EmbedCartridgeStrategy.EmbeddableCartridgeDiff additionalOperations) {
        int result = this.openAdditionalOperationsDialog(NLS.bind((String)"{0} Cartridges", (Object)(add ? "Add" : "Remove")), this.createEmbeddingOperationMessage(add, additionalOperations));
        switch (result) {
            case 1: {
                this.executeAdditionalOperations(cartridge, additionalOperations);
                break;
            }
            case 0: {
                this.undoAdditionOrRemoval(add, cartridge);
            }
        }
    }

    public int openAdditionalOperationsDialog(String title, String message) {
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{"Cancel", "Apply", "Ignore"}, 1);
        return dialog.open();
    }

    private String createEmbeddingOperationMessage(boolean adding, EmbedCartridgeStrategy.EmbeddableCartridgeDiff diff) {
        StringBuilder builder = new StringBuilder();
        builder.append(NLS.bind((String)"If you want to {0} {1}, it is suggested you:", (Object)(adding ? "add" : "remove"), (Object)new CartridgeToStringConverter().toString(diff.getCartridge())));
        builder.append(diff.toString());
        if (diff.hasRemovals()) {
            builder.append("\n\nRemoving cartridges is not reversible and may cause you to loose the data you have stored in it.");
        }
        builder.append("\n\nDo you want to Apply or Ignore these suggestions??");
        return builder.toString();
    }

    private void executeAdditionalOperations(ICartridge cartridge, EmbedCartridgeStrategy.EmbeddableCartridgeDiff diff) {
        if (this.createApplications(diff.getApplicationAdditions(), this.getPageModel().getDomain())) {
            this.uncheckEmbeddableCartridges(diff.getRemovals());
            this.checkEmbeddableCartridges(diff.getAdditions());
        } else {
            this.getPageModel().uncheckEmbeddedCartridge(cartridge);
        }
    }

    private void undoAdditionOrRemoval(boolean add, ICartridge cartridge) throws OpenShiftException {
        if (add) {
            this.getPageModel().uncheckEmbeddedCartridge(cartridge);
        } else {
            this.getPageModel().checkEmbeddedCartridge(cartridge);
        }
    }

    private void uncheckEmbeddableCartridges(List<ICartridge> removals) throws OpenShiftException {
        for (ICartridge embeddableCartridge : removals) {
            this.getPageModel().uncheckEmbeddedCartridge(embeddableCartridge);
        }
    }

    private void checkEmbeddableCartridges(List<ICartridge> additions) throws OpenShiftException {
        for (ICartridge embeddableCartridge : additions) {
            this.getPageModel().checkEmbeddedCartridge(embeddableCartridge);
        }
    }

    private boolean createApplications(List<ICartridge> applicationAdditions, IDomain domain) {
        for (ICartridge cartridge : applicationAdditions) {
            if (!LatestVersionOf.jenkins().matches(cartridge)) {
                throw new UnsupportedOperationException("only jenkins applications may currently be created.");
            }
            if (this.createJenkinsApplication(domain)) continue;
            return false;
        }
        return true;
    }

    private boolean createJenkinsApplication(IDomain domain) {
        IGearProfile gear;
        String name;
        block5: {
            name = this.openJenkinsApplicationDialog();
            if (name == null) {
                return false;
            }
            gear = this.getFirstAvailableGearProfile(domain);
            if (gear != null) break block5;
            Status status = new Status(4, "org.jboss.tools.openshift.express.ui", "Could not find any available gear profiles.");
            new ErrorDialog(this.getShell(), "Error", "Could create jenkins application.", (IStatus)status, -1).open();
            return false;
        }
        try {
            IStandaloneCartridge jenkinsCartridge = LatestVersionOf.jenkins().get(domain.getUser());
            CreateApplicationJob createJob = new CreateApplicationJob(name, ApplicationScale.NO_SCALE, gear, (ICartridge)jenkinsCartridge, domain);
            WizardUtils.runInWizard((Job)createJob, (DelegatingProgressMonitor)createJob.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            IStatus result = createJob.getResult();
            if (JobUtils.isOk((IStatus)result)) {
                IApplication application = createJob.getApplication();
                this.openLogDialog(application, createJob.isTimeouted(result));
                WaitForApplicationJob job = new WaitForApplicationJob(application, this.getShell());
                IStatus waitStatus = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
                return JobUtils.isOk((IStatus)waitStatus);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.jboss.tools.openshift.express.ui", e.getMessage());
            new ErrorDialog(this.getShell(), "Error", "Could not create jenkins application.", (IStatus)status, -1).open();
        }
        return false;
    }

    private IGearProfile getFirstAvailableGearProfile(IDomain domain) throws OpenShiftEndpointException {
        IGearProfile gear = null;
        List gears = domain.getAvailableGearProfiles();
        if (gears != null && !gears.isEmpty()) {
            gear = (IGearProfile)gears.get(0);
        }
        return gear;
    }

    private String openJenkinsApplicationDialog() {
        JenkinsApplicationDialog dialog = new JenkinsApplicationDialog(this.getShell());
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getValue();
    }

    private void openLogDialog(IApplication application, boolean isTimeouted) {
        final CreationLogDialog.LogEntry[] entries = LogEntryFactory.create(application, isTimeouted);
        if (entries.length == 0) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new CreationLogDialog(FullfillRequirementsCheckStrategy.this.getShell(), entries).open();
            }
        });
    }

    private static class JenkinsApplicationDialog
    extends InputDialog {
        public JenkinsApplicationDialog(Shell shell) {
            super(shell, "New Jenkins application", "To embed Jenkins into your application, you first have to create a separate Jenkins application. Please provide a name for this new Jenkins application (letters and digits only):", null, (IInputValidator)new JenkinsNameValidator());
        }

        private static class JenkinsNameValidator
        implements IInputValidator {
            private JenkinsNameValidator() {
            }

            public String isValid(String input) {
                if (StringUtils.isEmpty((String)input)) {
                    return "You have to provide a name for the jenkins application";
                }
                if (!StringUtils.isAlphaNumeric((String)input)) {
                    return "The name may only contain letters and digits.";
                }
                return null;
            }
        }
    }
}

