/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenshiftUIMessages;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.DomainWizardModel;

public class NewDomainWizardPage
extends AbstractOpenShiftWizardPage {
    private DomainWizardModel pageModel;

    public NewDomainWizardPage(DomainWizardModel model, IWizard wizard) {
        this("New OpenShift Domain", "Please provide a new name for your new OpenShift domain", model, wizard);
    }

    protected NewDomainWizardPage(String title, String description, DomainWizardModel model, IWizard wizard) {
        super(title, description, "", wizard);
        this.pageModel = model;
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(parent);
        Label namespaceLabel = new Label(parent, 0);
        namespaceLabel.setText(OpenshiftUIMessages.DomainName);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)namespaceLabel);
        Text namespaceText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)namespaceText);
        ISWTObservableValue namespaceTextObservable = WidgetProperties.text((int)24).observe((Widget)namespaceText);
        NamespaceValidator namespaceValidator = new NamespaceValidator(namespaceTextObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)namespaceValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)namespaceValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        IObservableValue namespaceModelObservable = BeanProperties.value((String)"domainId").observe((Object)this.pageModel);
        ValueBindingBuilder.bind((IObservableValue)namespaceTextObservable).to(namespaceModelObservable).in(dbc);
    }

    protected DomainWizardModel getModel() {
        return this.pageModel;
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    class NamespaceValidator
    extends MultiValidator {
        private final ISWTObservableValue domainNameObservable;

        public NamespaceValidator(ISWTObservableValue domainNameObservable) {
            this.domainNameObservable = domainNameObservable;
        }

        protected IStatus validate() {
            String domainName = (String)this.domainNameObservable.getValue();
            if (NewDomainWizardPage.this.pageModel.isCurrentDomainId(domainName)) {
                return ValidationStatus.cancel((String)NewDomainWizardPage.this.getDescription());
            }
            if (domainName.isEmpty()) {
                return ValidationStatus.cancel((String)OpenshiftUIMessages.EnterDomainName);
            }
            if (!StringUtils.isAlphaNumeric((String)domainName)) {
                return ValidationStatus.error((String)OpenshiftUIMessages.DomainNameMayHaveLettersAndDigits);
            }
            if (domainName.length() > 16) {
                return ValidationStatus.error((String)OpenshiftUIMessages.DomainNameMaximumLength);
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.domainNameObservable);
            return targets;
        }
    }
}

