/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.core.IConnectionsModelListener;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;

public class ManageDomainsWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_SELECTED_DOMAIN = "selectedDomain";
    public static final String PROPERTY_DOMAINS = "domains";
    private Connection connection;
    private IDomain selectedDomain;
    private List<IDomain> domains;
    private IConnectionsModelListener connectionChangeListener;

    public ManageDomainsWizardPageModel(IDomain domain, Connection connection) {
        this(connection);
        this.setSelectedDomain(domain);
    }

    public ManageDomainsWizardPageModel(Connection connection) {
        this.connection = connection;
        this.connectionChangeListener = this.onConnectionsChanged();
        ConnectionsModelSingleton.getInstance().addListener(this.connectionChangeListener);
    }

    private IConnectionsModelListener onConnectionsChanged() {
        return new IConnectionsModelListener(){

            public void connectionRemoved(Connection connection) {
                ManageDomainsWizardPageModel.this.connection = null;
                ManageDomainsWizardPageModel.this.loadDomains();
            }

            public void connectionChanged(Connection connection) {
                ManageDomainsWizardPageModel.this.setDomains(Collections.<IDomain>emptyList());
                ManageDomainsWizardPageModel.this.loadDomains();
            }

            public void connectionAdded(Connection connection) {
                ManageDomainsWizardPageModel.this.loadDomains();
            }
        };
    }

    public void loadDomains() {
        if (this.connection == null) {
            this.setDomains(Collections.<IDomain>emptyList());
        } else {
            this.setDomains(this.connection.getDomains());
        }
    }

    public void setDomains(List<IDomain> domains) {
        this.domains = domains;
        this.firePropertyChange(PROPERTY_DOMAINS, null, this.domains);
    }

    public List<IDomain> getDomains() {
        return this.domains;
    }

    public void refresh() {
        this.connection.refresh();
        this.loadDomains();
    }

    public void setSelectedDomain(IDomain domain) {
        this.selectedDomain = domain;
        this.firePropertyChange(PROPERTY_SELECTED_DOMAIN, this.selectedDomain, this.selectedDomain);
    }

    public IDomain getSelectedDomain() {
        return this.selectedDomain;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void dispose() {
        ConnectionsModelSingleton.getInstance().removeListener(this.connectionChangeListener);
    }
}

