/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.template;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.AbstractApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplateCategory;

public class ApplicationTemplateCategory
extends AbstractApplicationTemplate
implements IApplicationTemplateCategory {
    private List<IApplicationTemplate> children = new ArrayList<IApplicationTemplate>();

    public ApplicationTemplateCategory(String name, String description, IApplicationTemplate ... children) {
        super(name, description, children);
    }

    @Override
    public List<IApplicationTemplate> getChildren() {
        return this.children;
    }

    @Override
    public void clearChildren() {
        this.children.clear();
        this.firePropertyChange("children", null, this.children);
    }

    @Override
    public IApplicationTemplate addChild(IApplicationTemplate child) {
        this.children.add(child);
        this.fireIndexedPropertyChange("children", this.children.size() - 1, null, child);
        return this;
    }

    @Override
    public IApplicationTemplate addChildren(List<IApplicationTemplate> templates) {
        this.children.addAll(templates);
        this.firePropertyChange("children", null, this.children);
        return this;
    }

    @Override
    public boolean isMatching(String expression) {
        boolean matching = super.isMatching(expression);
        if (matching) {
            return true;
        }
        return this.isMatchingChildren(StringUtils.toLowerCase((String)expression));
    }

    private boolean isMatchingChildren(String expression) {
        for (IApplicationTemplate template : this.children) {
            if (!template.isMatching(expression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddRemoveCartridges() {
        return false;
    }

    @Override
    public boolean canCreateApplication() {
        return false;
    }

    @Override
    public boolean isInitialGitUrlEditable() {
        return false;
    }

    @Override
    public boolean isCodeAnything() {
        return false;
    }
}

