/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.ImportFailedException;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.project.AbstractProjectImportOperation;

public class MavenProjectImportOperation
extends AbstractProjectImportOperation {
    private static final String POM_FILE = "pom.xml";

    public MavenProjectImportOperation(File projectFolder) {
        super(projectFolder);
    }

    public List<IProject> importToWorkspace(IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
        IProjectConfigurationManager configurationManager = mavenPlugin.getProjectConfigurationManager();
        MavenModelManager modelManager = mavenPlugin.getMavenModelManager();
        Set<MavenProjectInfo> projectInfos = this.getMavenProjects(this.getProjectDirectory(), modelManager, monitor);
        ProjectImportConfiguration projectImportConfiguration = new ProjectImportConfiguration();
        List importResults = configurationManager.importProjects(projectInfos, projectImportConfiguration, monitor);
        return this.validate(this.toProjects(importResults));
    }

    private List<IProject> toProjects(List<IMavenProjectImportResult> importResults) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IMavenProjectImportResult importResult : importResults) {
            IProject project = importResult.getProject();
            if (project == null) continue;
            projects.add(importResult.getProject());
        }
        return projects;
    }

    private List<IProject> validate(List<IProject> projects) {
        if (projects.size() == 0) {
            throw new ImportFailedException(NLS.bind((String)"There was a maven related error that prevented us from importing the project. We encourage you to look into the pom in the cloned repository at {0}.\n One of the possible reasons is that there is already a project in your workspace that matches the maven name of the OpenShift application. You can then rename your workspace project and start over again.\n", (Object)this.getProjectDirectory()), new Object[0]);
        }
        return projects;
    }

    private Set<MavenProjectInfo> getMavenProjects(File directory, MavenModelManager modelManager, IProgressMonitor monitor) throws InterruptedException {
        LocalProjectScanner scanner = new LocalProjectScanner(directory.getParentFile(), directory.toString(), false, modelManager);
        scanner.run(monitor);
        return this.collectProjects(scanner.getProjects());
    }

    public boolean isMavenProject() {
        if (!this.isReadable(this.getProjectDirectory()) || !this.getProjectDirectory().isDirectory()) {
            return false;
        }
        return this.isReadable(new File(this.getProjectDirectory(), POM_FILE));
    }

    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }
}

