/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.util.FileUtils;
import org.jboss.tools.openshift.express.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.express.internal.ui.UnCommittedChangesException;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.AbstractImportApplicationOperation;

public class MergeIntoGitSharedProject
extends AbstractImportApplicationOperation {
    public MergeIntoGitSharedProject(String projectName, IApplication application, String remoteName, List<IOpenShiftMarker> markers, Connection user) {
        super(projectName, application, remoteName, markers, user);
    }

    @Override
    public IProject execute(IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, IOException, CoreException, URISyntaxException, NoWorkTreeException, GitAPIException {
        IProject project = this.getProject();
        Assert.isTrue((boolean)EGitUtils.isSharedWithGit((IProject)project));
        if (EGitUtils.isDirty((IProject)project, (boolean)false, (IProgressMonitor)monitor)) {
            throw new UnCommittedChangesException("The project {0} has uncommitted changes. Please commit those changes first.", project.getName());
        }
        this.addToModified(this.copyOpenshiftConfigurations(this.getApplication(), this.getRemoteName(), project, monitor));
        this.addToModified((IResource)this.setupGitIgnore(project, monitor));
        this.addToModified(this.setupOpenShiftMavenProfile(this.getApplication(), project, monitor));
        this.addSettingsFile(project, monitor);
        this.addToModified(this.setupMarkers(project, monitor));
        this.addRemote(this.getRemoteName(), this.getApplication().getGitUrl(), project);
        return project;
    }

    private Collection<IResource> copyOpenshiftConfigurations(IApplication application, String remoteName, IProject project, IProgressMonitor monitor) throws IOException, CoreException, OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        Assert.isLegal((project != null ? 1 : 0) != 0);
        monitor.subTask(NLS.bind((String)"Copying openshift configuration to project {0}...", (Object)project.getName()));
        File tmpFolder = FileUtils.getRandomTmpFolder();
        this.cloneRepository(application, remoteName, tmpFolder, false, monitor);
        Collection copiedResources = ResourceUtils.copy((File)tmpFolder, (String[])new String[]{".openshift", "deployments", "pom.xml"}, (IProject)project, (IProgressMonitor)monitor);
        FileUtil.safeDelete((File)tmpFolder);
        return copiedResources;
    }
}

