/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.util.RegExUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.core.GitIgnore;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.marker.IOpenShiftMarker;
import org.jboss.tools.openshift.express.internal.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.express.internal.core.util.DeployFolder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIException;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.IImportApplicationStrategy;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.importoperation.OpenShiftMavenProfile;

abstract class AbstractImportApplicationOperation
implements IImportApplicationStrategy {
    private String projectName;
    private IApplication application;
    private String remoteName;
    protected List<IResource> modifiedResources;
    private Connection user;
    private List<IOpenShiftMarker> markers;

    public AbstractImportApplicationOperation(String projectName, IApplication application, String remoteName, List<IOpenShiftMarker> markers, Connection user) {
        this.projectName = projectName;
        this.application = application;
        this.remoteName = remoteName;
        this.markers = markers;
        this.modifiedResources = new ArrayList<IResource>();
        this.user = user;
    }

    protected String getProjectName() {
        return this.projectName;
    }

    private IProject getProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        Assert.isTrue((project != null && project.exists() ? 1 : 0) != 0, (String)NLS.bind((String)"Could not find project {0} in your workspace.", (Object)name));
        return project;
    }

    protected IProject getProject() {
        return this.getProject(this.getProjectName());
    }

    protected IApplication getApplication() {
        return this.application;
    }

    protected String getRemoteName() {
        return this.remoteName;
    }

    protected Connection getUser() {
        return this.user;
    }

    protected void addToModified(Collection<IResource> resources) {
        if (resources == null) {
            return;
        }
        this.modifiedResources.addAll(resources);
    }

    protected void addToModified(IResource resource) {
        if (resource == null) {
            return;
        }
        this.modifiedResources.add(resource);
    }

    protected File cloneRepository(IApplication application, String remoteName, File destination, boolean addToRepoView, IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        monitor.subTask(NLS.bind((String)"Cloning repository for application {0}...", (Object)application.getName()));
        EGitUIUtils.ensureEgitUIIsStarted();
        if (addToRepoView) {
            EGitUtils.cloneRepository((String)application.getGitUrl(), (String)remoteName, (File)destination, (CloneOperation.PostCloneTask)EGitUIUtils.ADD_TO_REPOVIEW_TASK, (IProgressMonitor)monitor);
        } else {
            EGitUtils.cloneRepository((String)application.getGitUrl(), (String)remoteName, (File)destination, (IProgressMonitor)monitor);
        }
        return destination;
    }

    protected void addAndCommitModifiedResource(IProject project, IProgressMonitor monitor) throws CoreException, OpenShiftException, NoWorkTreeException, IOException, GitAPIException {
        EGitUtils.checkedGetRepository((IProject)project);
        new AddToIndexOperation(this.modifiedResources).execute(monitor);
        if (EGitUtils.isDirty((IProject)project, (IProgressMonitor)monitor)) {
            EGitUtils.commit((IProject)project, (IProgressMonitor)monitor);
        }
    }

    protected IFile setupGitIgnore(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        GitIgnore gitIgnore = new GitIgnore(project);
        gitIgnore.add("target").add(".settings/*").add("!.settings/.jsdtscope").add(".project").add(".classpath");
        return gitIgnore.write(monitor);
    }

    protected void addRemote(String remoteName, String gitUrl, IProject project) throws MalformedURLException, URISyntaxException, IOException, OpenShiftException, CoreException {
        Repository repository = EGitUtils.getRepository((IProject)project);
        RemoteConfig config = EGitUtils.getRemoteByName((String)remoteName, (Repository)repository);
        if (config != null) {
            if (EGitUtils.hasRemoteUrl((Pattern)Pattern.compile(RegExUtils.escapeRegex((String)gitUrl)), (RemoteConfig)config)) {
                return;
            }
            throw new OpenShiftUIException("Could not enable OpenShift on project \"{0}\". There already is a remote called \"{1}\" that points to a different git repository.", project.getName(), remoteName);
        }
        EGitUtils.addRemoteTo((String)this.getRemoteName(), (String)this.getApplication().getGitUrl(), (Repository)repository);
    }

    protected IResource setupOpenShiftMavenProfile(IApplication application, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!OpenShiftMavenProfile.isMavenProject(project)) {
            return null;
        }
        OpenShiftMavenProfile profile = new OpenShiftMavenProfile(project, "org.jboss.tools.openshift.express.ui");
        if (profile.existsInPom()) {
            return null;
        }
        profile.addToPom(project.getName(), this.getDeployFolder(application));
        return profile.savePom(monitor);
    }

    private String getDeployFolder(IApplication application) {
        DeployFolder deployFolder = DeployFolder.getByCartridgeName((String)application.getCartridge().getName());
        if (deployFolder == null) {
            return null;
        }
        return deployFolder.getDeployFolder();
    }

    protected List<IResource> setupMarkers(IProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<IResource> newMarkers = new ArrayList<IResource>();
        for (IOpenShiftMarker marker : this.markers) {
            IFile file = marker.addTo(project, monitor);
            if (file == null) continue;
            newMarkers.add((IResource)file);
        }
        return newMarkers;
    }

    protected IResource addSettingsFile(IProject project, IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)"Adding settings to project {0}", (Object)project.getName()));
        IApplication app = this.getApplication();
        OpenShiftServerUtils.updateOpenshiftProjectSettings((IProject)project, (IApplication)app, (IDomain)app.getDomain(), (Connection)this.getUser(), (String)this.getRemoteName(), (String)OpenShiftServerUtils.getDefaultDeployFolder((IApplication)app));
        return project.getFolder(".settings");
    }

    protected IProject getSettingsProject(List<IProject> importedProjects) {
        IProject mainProject;
        block3: {
            block2: {
                if (importedProjects == null) {
                    return null;
                }
                mainProject = null;
                if (importedProjects.size() != 1) break block2;
                if (!EGitUtils.hasDotGitFolder((IProject)importedProjects.get(0))) break block3;
                mainProject = importedProjects.get(0);
                break block3;
            }
            for (IProject project : importedProjects) {
                if (!EGitUtils.hasDotGitFolder((IProject)project)) continue;
                mainProject = project;
                break;
            }
        }
        return mainProject;
    }
}

