/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.details;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.propertytable.AbstractPropertyTableContentProvider;
import org.jboss.tools.openshift.express.internal.ui.propertytable.ContainerElement;
import org.jboss.tools.openshift.express.internal.ui.propertytable.StringElement;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class ApplicationDetailsContentProvider
extends AbstractPropertyTableContentProvider {
    @Override
    public Object[] getElements(Object inputElement) {
        ArrayList<ContainerElement> elements = new ArrayList<ContainerElement>();
        if (inputElement instanceof IApplication) {
            IApplication application = (IApplication)inputElement;
            try {
                elements.add(new StringElement("Name", application.getName()));
                elements.add(new StringElement("Public URL", application.getApplicationUrl().toString(), true));
                elements.add(new StringElement("Type", application.getCartridge().getName()));
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss");
                elements.add(new StringElement("Created on", format.format(application.getCreationTime())));
                elements.add(new StringElement("UUID", application.getUUID()));
                elements.add(new StringElement("Git URL", application.getGitUrl()));
                elements.add(new StringElement("SSH Connection", this.getSSHConnectionString(application.getGitUrl())));
                elements.add(this.createCartridges(application));
            }
            catch (Exception e) {
                Logger.error(NLS.bind((String)"Could not display details for OpenShift application {0}", (Object)application.getName()), e);
            }
        }
        return elements.toArray();
    }

    protected String getSSHConnectionString(String gitUrl) {
        return EGitUtils.getGitUsername((String)gitUrl) + '@' + EGitUtils.getGitHost((String)gitUrl);
    }

    private ContainerElement createCartridges(IApplication application) throws OpenShiftException, SocketTimeoutException {
        ContainerElement cartridgesContainer = new ContainerElement("Cartridges");
        for (IEmbeddedCartridge cartridge : application.getEmbeddedCartridges()) {
            cartridgesContainer.add(new StringElement(cartridge.getName(), StringUtils.toStringOrNull((Object)cartridge.getUrl()), true, cartridgesContainer));
        }
        return cartridgesContainer;
    }
}

