/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.DataBindingUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.SelectApplicationWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.details.ApplicationDetailsDialog;

public class SelectApplicationWizardPage
extends AbstractOpenShiftWizardPage {
    private static final String COMMON_VIEWER_ID = "org.jboss.tools.openshift.express.internal.ui.wizard.application.SelectApplicationWizardPage";
    private final SelectApplicationWizardPageModel pageModel;
    private TreeViewer applicationsTreeViewer;

    public SelectApplicationWizardPage(OpenShiftApplicationWizardModel wizardModel, IWizard wizard) {
        super("Select Existing Application", "Please choose the existing application that you want to import.", "Select Existing Application", wizard);
        this.pageModel = new SelectApplicationWizardPageModel(wizardModel);
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Label existingApplicationsLabel = new Label(parent, 0);
        existingApplicationsLabel.setText("Existing Applications:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)existingApplicationsLabel);
        this.applicationsTreeViewer = this.createApplicationsTree(parent, dbc);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).span(1, 4).applyTo(this.applicationsTreeViewer.getControl());
        Binding selectedApplicationBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singlePostSelection().observe((Viewer)this.applicationsTreeViewer)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof IApplication)) {
                    return ValidationStatus.cancel((String)"Please choose the existing application that you want to import.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"selectedApplication").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedApplicationBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button detailsButton = new Button(parent, 8);
        detailsButton.setText("De&tails...");
        GridDataFactory.fillDefaults().align(4, 128).hint(80, -1).applyTo((Control)detailsButton);
        DataBindingUtils.bindEnablementToValidationStatus((Control)detailsButton, (int)0, (DataBindingContext)dbc, (Binding[])new Binding[]{selectedApplicationBinding});
        detailsButton.addSelectionListener((SelectionListener)this.onDetails(dbc));
        Label filler = new Label(parent, 0);
        GridDataFactory.fillDefaults().applyTo((Control)filler);
        Button refreshButton = new Button(parent, 8);
        refreshButton.setText("R&efresh");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)refreshButton);
        refreshButton.addSelectionListener((SelectionListener)this.onRefresh(dbc));
        filler = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)filler);
    }

    protected TreeViewer createApplicationsTree(Composite parent, DataBindingContext dbc) {
        CommonViewer commonViewer = new CommonViewer(COMMON_VIEWER_ID, parent, 2820);
        INavigatorContentService contentService = NavigatorContentServiceFactory.INSTANCE.createContentService(COMMON_VIEWER_ID, (StructuredViewer)commonViewer);
        contentService.createCommonContentProvider();
        contentService.createCommonLabelProvider();
        return commonViewer;
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        this.pageModel.loadOpenShiftResources();
        this.setViewerInput(this.pageModel);
    }

    private SelectionAdapter onRefresh(final DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    WizardUtils.runInWizard((Job)new Job("Loading applications..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            SelectApplicationWizardPage.this.pageModel.refresh();
                            SelectApplicationWizardPage.this.setViewerInput(SelectApplicationWizardPage.this.pageModel);
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)SelectApplicationWizardPage.this.getContainer(), (DataBindingContext)dbc);
                }
                catch (Exception e) {
                    Logger.error("Failed to refresh applications list", e);
                }
            }
        };
    }

    private SelectionAdapter onDetails(DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ApplicationDetailsDialog(SelectApplicationWizardPage.this.pageModel.getSelectedApplication(), SelectApplicationWizardPage.this.getShell()).open();
            }
        };
    }

    private void setViewerInput(final SelectApplicationWizardPageModel pageModel) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SelectApplicationWizardPage.this.applicationsTreeViewer.setInput((Object)pageModel.getConnection());
            }
        });
    }

    public IApplication getSelectedApplication() {
        return this.pageModel.getSelectedApplication();
    }
}

