/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.ui.utils.PojoEventBridge;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.IOpenShiftApplicationWizardModel;

public class ProjectAndServerAdapterSettingsWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_APPLICATION_NAME = "applicationName";
    public static final String PROPERTY_IS_NEW_PROJECT = "newProject";
    public static final String PROPERTY_PROJECT_NAME = "projectName";
    public static final String PROPERTY_CREATE_SERVER_ADAPTER = "createServerAdapter";
    public static final String PROPERTY_SKIP_MAVEN_BUILD = "skipMavenBuild";
    private IOpenShiftApplicationWizardModel wizardModel;

    public ProjectAndServerAdapterSettingsWizardPageModel(IOpenShiftApplicationWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.setNewProject(wizardModel.getProject() == null);
        this.setCreateServerAdapter(true);
        this.setupWizardModelListeners(wizardModel);
    }

    private void setupWizardModelListeners(IOpenShiftApplicationWizardModel wizardModel) {
        new PojoEventBridge().listenTo(PROPERTY_APPLICATION_NAME, wizardModel).forwardTo(PROPERTY_APPLICATION_NAME, (ObservablePojo)this);
    }

    public void setNewProject(boolean newProject) {
        this.firePropertyChange(PROPERTY_IS_NEW_PROJECT, this.wizardModel.isNewProject(), this.wizardModel.setNewProject(newProject));
        if (this.wizardModel.isNewProject()) {
            this.setProjectName(null);
        }
    }

    public boolean isNewProject() {
        return this.wizardModel.isNewProject();
    }

    public void setProjectName(String projectName) {
        this.firePropertyChange(PROPERTY_PROJECT_NAME, this.wizardModel.getProjectName(), this.wizardModel.setProjectName(projectName));
    }

    public String getProjectName() {
        return this.wizardModel.getProjectName();
    }

    public void setCreateServerAdapter(boolean createServerAdapter) {
        this.firePropertyChange(PROPERTY_CREATE_SERVER_ADAPTER, this.wizardModel.isCreateServerAdapter(), this.wizardModel.setCreateServerAdapter(createServerAdapter));
    }

    public boolean isCreateServerAdapter() {
        return this.wizardModel.isCreateServerAdapter();
    }

    public void setSkipMavenBuild(boolean skipMavenBuild) {
        this.firePropertyChange(PROPERTY_SKIP_MAVEN_BUILD, this.wizardModel.isSkipMavenBuild(), this.wizardModel.setSkipMavenBuild(skipMavenBuild));
    }

    public boolean isSkipMavenBuild() {
        return this.wizardModel.isSkipMavenBuild();
    }

    public String getApplicationName() {
        return this.wizardModel.getApplicationName();
    }

    public void reset() {
        this.setNewProject(this.wizardModel.isNewProject());
        this.setProjectName(this.wizardModel.getProjectName());
        this.setCreateServerAdapter(this.wizardModel.isCreateServerAdapter());
    }
}

