/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.preferences.OpenShiftPreferences;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.ImportFailedException;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.WontOverwriteException;
import org.jboss.tools.openshift.express.internal.ui.job.CreateApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.job.FireConnectionsChangedJob;
import org.jboss.tools.openshift.express.internal.ui.job.RefreshConnectionJob;
import org.jboss.tools.openshift.express.internal.ui.job.WaitForApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.wizard.CreationLogDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.LogEntryFactory;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ApplicationConfigurationWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ApplicationTemplateWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.GitCloningSettingsWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.ProjectAndServerAdapterSettingsWizardPage;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ICodeAnythingApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.ConnectionWizardPage;

public abstract class OpenShiftApplicationWizard
extends Wizard
implements IImportWizard,
INewWizard {
    private final boolean showCredentialsPage;
    private final OpenShiftApplicationWizardModel model;

    OpenShiftApplicationWizard(Connection connection, IDomain domain, IApplication application, IProject project, boolean useExistingApplication, boolean showCredentialsPage, String wizardTitle) {
        this.setWindowTitle(wizardTitle);
        this.setNeedsProgressMonitor(true);
        this.model = new OpenShiftApplicationWizardModel(connection, domain, application, project, useExistingApplication);
        this.showCredentialsPage = showCredentialsPage;
    }

    protected void openError(final String title, final String message) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)OpenShiftApplicationWizard.this.getShell(), (String)title, (String)message);
            }
        });
    }

    protected boolean askForConfirmation(final String message, final String applicationName) {
        final boolean[] confirmed = new boolean[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                confirmed[0] = MessageDialog.openConfirm((Shell)OpenShiftApplicationWizard.this.getShell(), (String)NLS.bind((String)"Import OpenShift Application ", (Object)applicationName), (String)message);
            }
        });
        return confirmed[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (this.showCredentialsPage) {
            this.addPage((IWizardPage)new ConnectionWizardPage((IWizard)this, this.model));
        }
        this.addPage((IWizardPage)new ApplicationTemplateWizardPage((IWizard)this, this.model));
        this.addPage((IWizardPage)new ApplicationConfigurationWizardPage((IWizard)this, this.model));
        this.addPage((IWizardPage)new ProjectAndServerAdapterSettingsWizardPage((IWizard)this, this.model));
        this.addPage(new GitCloningSettingsWizardPage(this, this.model));
    }

    public boolean performFinish() {
        if (!this.model.isUseExistingApplication()) {
            IStatus status = this.createApplication();
            if (!this.handleOpenShiftError(NLS.bind((String)"create application {0}", (Object)StringUtils.null2emptyString((String)this.model.getApplicationName())), status)) {
                return false;
            }
            status = this.waitForApplication(this.model.getApplication());
            if (!this.handleOpenShiftError(NLS.bind((String)"wait for application {0} to become reachable", (Object)StringUtils.null2emptyString((String)this.model.getApplicationName())), status)) {
                return false;
            }
            new FireConnectionsChangedJob(this.model.getConnection()).schedule();
            this.saveCodeAnythingUrl();
        }
        if (!this.importProject()) {
            return false;
        }
        return this.createServerAdapter();
    }

    private boolean handleOpenShiftError(String operation, IStatus status) {
        if (JobUtils.isCancel((IStatus)status) && 1 == status.getCode()) {
            this.closeWizard();
        }
        if (!JobUtils.isOk((IStatus)status)) {
            if (this.model.getConnection() != null) {
                new JobChainBuilder((Job)new RefreshConnectionJob(this.model.getConnection())).runWhenDone((Job)new FireConnectionsChangedJob(this.model.getConnection())).schedule();
            }
            return false;
        }
        return true;
    }

    private void closeWizard() {
        IWizardContainer container = this.getContainer();
        if (container instanceof WizardDialog) {
            ((WizardDialog)container).close();
        }
    }

    private IStatus waitForApplication(IApplication application) {
        try {
            WaitForApplicationJob job = new WaitForApplicationJob(application, this.getShell());
            IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            return status;
        }
        catch (Exception e) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not wait for application {0} to become reachable", (Object)application.getName()), e);
        }
    }

    private boolean importProject() {
        try {
            DelegatingProgressMonitor delegatingMonitor = new DelegatingProgressMonitor();
            IStatus jobResult = WizardUtils.runInWizard((Job)new ImportJob(delegatingMonitor), (DelegatingProgressMonitor)delegatingMonitor, (IWizardContainer)this.getContainer());
            return JobUtils.isOk((IStatus)jobResult);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Could not create local git repository.", (IStatus)OpenShiftUIActivator.createErrorStatus("An exception occurred while creating local git repository.", e));
            return false;
        }
    }

    private void saveCodeAnythingUrl() {
        IApplicationTemplate template = this.model.getSelectedApplicationTemplate();
        if (!(template instanceof ICodeAnythingApplicationTemplate)) {
            return;
        }
        String url = ((ICodeAnythingApplicationTemplate)template).getUrl();
        OpenShiftPreferences.INSTANCE.addDownloadableStandaloneCartUrl(url);
    }

    private boolean createServerAdapter() {
        block3: {
            try {
                if (this.model.isCreateServerAdapter()) break block3;
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)NLS.bind((String)"Could not create server adapter for new project {0}.", (Object)this.model.getProjectName()), (IStatus)OpenShiftUIActivator.createErrorStatus(e.getMessage(), e));
                return false;
            }
        }
        IServer server = this.model.createServerAdapter((IProgressMonitor)new DelegatingProgressMonitor());
        return server != null;
    }

    private IStatus createApplication() {
        try {
            CreateApplicationJob job = new CreateApplicationJob(this.model.getApplicationName(), this.model.getApplicationScale(), this.model.getApplicationGearProfile(), this.model.getInitialGitUrl(), this.model.getEnvironmentVariables(), this.model.getCartridges(), this.model.getDomain());
            IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)job.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
            IApplication application = job.getApplication();
            this.model.setApplication(application);
            if (status.isOK()) {
                this.openLogDialog(application, job.isTimeouted(status));
                this.openLogDialog(job.getAddedCartridges(), job.isTimeouted(status));
            }
            return status;
        }
        catch (Exception e) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not create application {0}", (Object)this.model.getApplicationName()), e);
        }
    }

    private void openLogDialog(IApplication application, boolean isTimeouted) {
        final CreationLogDialog.LogEntry[] logEntries = LogEntryFactory.create(application, isTimeouted);
        if (logEntries.length == 0) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new CreationLogDialog(OpenShiftApplicationWizard.this.getShell(), logEntries).open();
            }
        });
    }

    private void openLogDialog(List<IEmbeddedCartridge> embeddableCartridges, boolean isTimeouted) {
        final CreationLogDialog.LogEntry[] logEntries = LogEntryFactory.create(embeddableCartridges, isTimeouted);
        if (logEntries == null || logEntries.length == 0) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                new CreationLogDialog(OpenShiftApplicationWizard.this.getShell(), logEntries).open();
            }
        });
    }

    OpenShiftApplicationWizardModel getModel() {
        return this.model;
    }

    public void dispose() {
        this.model.dispose();
    }

    public boolean isCreateServerAdapter() {
        return this.model.isCreateServerAdapter();
    }

    private class ImportJob
    extends WorkspaceJob {
        private DelegatingProgressMonitor delegatingMonitor;

        public ImportJob(DelegatingProgressMonitor delegatingMonitor) {
            super("Importing project to workspace...");
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.delegatingMonitor = delegatingMonitor;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                this.delegatingMonitor.add(monitor);
                if (OpenShiftApplicationWizard.this.model.isNewProject()) {
                    OpenShiftApplicationWizard.this.model.importProject((IProgressMonitor)this.delegatingMonitor);
                } else if (!OpenShiftApplicationWizard.this.model.isGitSharedProject()) {
                    if (!OpenShiftApplicationWizard.this.askForConfirmation(NLS.bind((String)"OpenShift application {0} will be enabled on project {1} by copying OpenShift configuration from server to local project and connecting local project to OpenShift Git repository.\nThe local project will be committed to local Git repository upon confirmation and further publishing will eventually override existing remote content.\n\nThis cannot be undone. Do you wish to continue?", (Object)OpenShiftApplicationWizard.this.model.getApplicationName(), (Object)OpenShiftApplicationWizard.this.model.getProjectName()), OpenShiftApplicationWizard.this.model.getApplicationName())) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    OpenShiftApplicationWizard.this.model.mergeIntoUnsharedProject((IProgressMonitor)this.delegatingMonitor);
                } else {
                    if (!OpenShiftApplicationWizard.this.askForConfirmation(NLS.bind((String)"OpenShift application {0} will be enabled on project {1} by copying OpenShift configuration from server to local project and connecting local project to OpenShift Git repository.\nThe local project will be committed to local Git repository upon confirmation and further publishing will eventually override existing remote content.\n\nThis cannot be undone. Do you wish to continue?", (Object)OpenShiftApplicationWizard.this.model.getApplicationName(), (Object)OpenShiftApplicationWizard.this.model.getProjectName()), OpenShiftApplicationWizard.this.model.getApplicationName())) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    OpenShiftApplicationWizard.this.model.mergeIntoGitSharedProject((IProgressMonitor)this.delegatingMonitor);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (WontOverwriteException e) {
                OpenShiftApplicationWizard.this.openError("Project already present", e.getMessage());
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            catch (ImportFailedException e) {
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("Could not import project from application {0}.", (Throwable)((Object)e), OpenShiftApplicationWizard.this.model.getApplicationName());
                return iStatus;
            }
            catch (IOException e) {
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("Could not copy openshift configuration files to project {0}", e, OpenShiftApplicationWizard.this.model.getProjectName());
                return iStatus;
            }
            catch (OpenShiftException e) {
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("Could not import project to the workspace.", e);
                return iStatus;
            }
            catch (URISyntaxException e) {
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("The url of the remote git repository is not valid", e);
                return iStatus;
            }
            catch (InvocationTargetException e) {
                TransportException te = this.getTransportException(e);
                if (te != null) {
                    IStatus iStatus = OpenShiftUIActivator.createErrorStatus("Could not clone the repository. Authentication failed.\n Please make sure that you added your private key to the ssh preferences.", (Throwable)te);
                    return iStatus;
                }
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("An exception occurred while creating local git repository.", e);
                return iStatus;
            }
            catch (Exception e) {
                IStatus iStatus = OpenShiftUIActivator.createErrorStatus("Could not import project to the workspace.", e);
                return iStatus;
            }
            finally {
                this.delegatingMonitor.done();
            }
        }

        protected TransportException getTransportException(Throwable t) {
            if (t instanceof TransportException) {
                return (TransportException)t;
            }
            if (t instanceof InvocationTargetException) {
                return this.getTransportException(((InvocationTargetException)t).getTargetException());
            }
            if (t instanceof Exception) {
                return this.getTransportException(((Exception)t).getCause());
            }
            return null;
        }
    }
}

