/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IQuickstart;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.CartridgeNameComparator;
import org.jboss.tools.openshift.express.internal.core.QuickstartNameComparator;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.utils.OpenShiftUserPreferencesProvider;
import org.jboss.tools.openshift.express.internal.ui.utils.PojoEventBridge;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.ApplicationTemplateCategory;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.CartridgeApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.CodeAnythingApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplate;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.IApplicationTemplateCategory;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.template.QuickstartApplicationTemplate;

public class ApplicationTemplateWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_APPLICATION_TEMPLATES = "applicationTemplates";
    public static final String PROPERTY_EXISTING_APPLICATIONS = "existingApplications";
    public static final String PROPERTY_DOMAINS = "domains";
    public static final String PROPERTY_EXISTING_APPLICATION_NAME = "existingApplicationName";
    public static final String PROPERTY_EXISTING_APPLICATION = "existingApplication";
    public static final String PROPERTY_RESOURCES_LOADED = "resourcesLoaded";
    public static final String PROPERTY_SELECTED_APPLICATION_TEMPLATE = "selectedApplicationTemplate";
    public static final String PROPERTY_USE_EXISTING_APPLICATION = "useExistingApplication";
    private final OpenShiftApplicationWizardModel wizardModel;
    private String existingApplicationName;
    private List<IApplication> existingApplications = new ArrayList<IApplication>();
    private boolean resourcesLoaded = false;
    private List<IApplicationTemplate> applicationTemplates;
    private IApplicationTemplateCategory basicCartridgesCathegory = new ApplicationTemplateCategory("Basic Cartridges", "Web programming cartridges provided by OpenShift", new IApplicationTemplate[0]);
    private IApplicationTemplateCategory quickstartsCathegory = new ApplicationTemplateCategory("Quickstarts", "A quick way to try out a new technology with code and libraries preconfigured. You are responsible for updating core libraries for security updates", new IApplicationTemplate[0]);
    private OpenShiftUserPreferencesProvider openShiftUserPreferencesProvider = new OpenShiftUserPreferencesProvider();

    protected ApplicationTemplateWizardPageModel(OpenShiftApplicationWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.setExistingApplication(wizardModel.getApplication());
        this.setUseExistingApplication(wizardModel.isUseExistingApplication());
        this.setupWizardModelListeners(wizardModel);
    }

    private void setupWizardModelListeners(OpenShiftApplicationWizardModel wizardModel) {
        wizardModel.addPropertyChangeListener("domain", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object newValue = event.getNewValue();
                if (!(newValue instanceof List)) {
                    return;
                }
                ApplicationTemplateWizardPageModel.this.setExistingApplicationsFor((List)newValue);
            }
        });
        new PojoEventBridge().listenTo(PROPERTY_USE_EXISTING_APPLICATION, wizardModel).forwardTo(PROPERTY_USE_EXISTING_APPLICATION, (ObservablePojo)this);
        new PojoEventBridge().listenTo("application", wizardModel).forwardTo(PROPERTY_EXISTING_APPLICATION, (ObservablePojo)this);
    }

    public Connection getConnection() {
        return this.wizardModel.getConnection();
    }

    public String[] getExistingApplicationNames() {
        try {
            List<IApplication> applications = this.getExistingApplications();
            String[] applicationNames = new String[applications.size()];
            int i = 0;
            while (i < applications.size()) {
                applicationNames[i] = applications.get(i).getName();
                ++i;
            }
            return applicationNames;
        }
        catch (OpenShiftException e) {
            Logger.error("Failed to retrieve list of OpenShift applications", e);
            return new String[0];
        }
    }

    public List<IApplicationTemplate> getApplicationTemplates() {
        if (this.applicationTemplates == null) {
            this.applicationTemplates = this.createApplicationTemplates(this.createCartridgeApplicationTemplates(this.getStandaloneCartridges()));
        }
        return this.applicationTemplates;
    }

    protected List<IApplicationTemplate> createApplicationTemplates(List<IApplicationTemplate> standaloneCartridges) {
        ArrayList<IApplicationTemplate> applicationTemplates = new ArrayList<IApplicationTemplate>();
        applicationTemplates.add(this.basicCartridgesCathegory);
        applicationTemplates.add(this.quickstartsCathegory);
        applicationTemplates.add(new CodeAnythingApplicationTemplate());
        return applicationTemplates;
    }

    private List<IApplicationTemplate> createCartridgeApplicationTemplates(List<IStandaloneCartridge> cartridges) {
        ArrayList<IApplicationTemplate> cartridgeApplicationTemplates = new ArrayList<IApplicationTemplate>();
        if (cartridges != null) {
            for (IStandaloneCartridge cartridge : cartridges) {
                cartridgeApplicationTemplates.add(new CartridgeApplicationTemplate(cartridge));
            }
        }
        return cartridgeApplicationTemplates;
    }

    public boolean isUseExistingApplication() {
        return this.wizardModel.isUseExistingApplication();
    }

    public void setUseExistingApplication(boolean useExistingApplication) {
        this.firePropertyChange(PROPERTY_USE_EXISTING_APPLICATION, this.wizardModel.isUseExistingApplication(), this.wizardModel.setUseExistingApplication(useExistingApplication));
    }

    public String getExistingApplicationName() {
        return this.existingApplicationName;
    }

    public void setExistingApplicationName(String applicationName) throws OpenShiftException {
        this.setExistingApplication(this.getApplicationByName(applicationName, this.getDomains()));
    }

    protected IApplication getApplicationByName(String applicationName, List<IDomain> domains) {
        IApplication matchingApplication = null;
        if (domains != null && !StringUtils.isEmpty((String)applicationName)) {
            for (IDomain domain : domains) {
                IApplication application = domain.getApplicationByName(applicationName);
                if (application == null) continue;
                matchingApplication = application;
                break;
            }
        }
        return matchingApplication;
    }

    public void setExistingApplication(IApplication application) throws OpenShiftException {
        this.wizardModel.setApplication(application);
        if (application != null) {
            this.doSetExistingApplicationName(application.getName());
            this.setUseExistingApplication(true);
        } else {
            this.doSetExistingApplicationName(null);
        }
    }

    protected void doSetExistingApplicationName(String name) {
        this.existingApplicationName = name;
        this.firePropertyChange(PROPERTY_EXISTING_APPLICATION_NAME, this.existingApplicationName, this.existingApplicationName);
    }

    public IApplication getExistingApplication() {
        return this.wizardModel.getApplication();
    }

    public void setResourcesLoaded(boolean loaded) {
        this.resourcesLoaded = loaded;
        this.firePropertyChange(PROPERTY_RESOURCES_LOADED, this.resourcesLoaded, this.resourcesLoaded);
    }

    public boolean isResourcesLoaded() {
        return this.resourcesLoaded;
    }

    public void loadResources() throws OpenShiftException {
        Connection connection = this.getConnection();
        if (!this.wizardModel.isValid(connection)) {
            return;
        }
        this.setResourcesLoaded(false);
        this.ensureHasDomain();
        this.setDomains(connection.getDomains());
        this.setQuickstarts(connection.getQuickstarts());
        this.setStandaloneCartridges(connection.getStandaloneCartridges());
        this.setResourcesLoaded(true);
    }

    protected void setStandaloneCartridges(List<IStandaloneCartridge> cartridges) {
        cartridges = new ArrayList<IStandaloneCartridge>(cartridges);
        Collections.sort(cartridges, new CartridgeNameComparator());
        this.wizardModel.setAvailableStandaloneCartridges(cartridges);
        this.basicCartridgesCathegory.clearChildren();
        this.basicCartridgesCathegory.addChildren(this.createCartridgeApplicationTemplates(cartridges));
    }

    protected void setQuickstarts(List<IQuickstart> quickstarts) {
        quickstarts = new ArrayList<IQuickstart>(quickstarts);
        Collections.sort(quickstarts, new QuickstartNameComparator());
        this.quickstartsCathegory.clearChildren();
        this.quickstartsCathegory.addChildren(this.createQuickstartApplicationTemplates(quickstarts));
    }

    protected List<IApplicationTemplate> createQuickstartApplicationTemplates(List<IQuickstart> quickstarts) {
        ArrayList<IApplicationTemplate> templates = new ArrayList<IApplicationTemplate>();
        for (IQuickstart quickstart : quickstarts) {
            templates.add(new QuickstartApplicationTemplate(quickstart));
        }
        return templates;
    }

    protected List<IStandaloneCartridge> getStandaloneCartridges() {
        return this.wizardModel.getAvailableStandaloneCartridges();
    }

    protected void setDomains(List<IDomain> domains) {
        this.firePropertyChange(PROPERTY_DOMAINS, this.wizardModel.getDomains(), this.wizardModel.setDomains(domains));
        this.setExistingApplicationsFor(domains);
    }

    protected void ensureHasDomain() {
        this.wizardModel.setDefaultDomainIfRequired();
    }

    public IApplicationTemplate getSelectedApplicationTemplate() {
        return this.wizardModel.getSelectedApplicationTemplate();
    }

    public void setSelectedApplicationTemplate(IApplicationTemplate template) {
        this.firePropertyChange(PROPERTY_SELECTED_APPLICATION_TEMPLATE, this.wizardModel.getSelectedApplicationTemplate(), this.wizardModel.setSelectedApplicationTemplate(template));
        this.setExistingApplicationName(null);
    }

    public List<IDomain> getDomains() throws OpenShiftException {
        return this.wizardModel.getDomains();
    }

    protected void setExistingApplicationsFor(List<IDomain> domains) throws OpenShiftException {
        ArrayList<IApplication> existingApplications = new ArrayList<IApplication>();
        if (domains != null) {
            for (IDomain domain : domains) {
                existingApplications.addAll(domain.getApplications());
            }
        }
        this.setExistingApplications(existingApplications);
    }

    public void setExistingApplications(List<IApplication> applications) throws OpenShiftException {
        this.existingApplications = applications;
        this.firePropertyChange(PROPERTY_EXISTING_APPLICATIONS, this.existingApplications, this.existingApplications);
    }

    public List<IApplication> getExistingApplications() throws OpenShiftException {
        return this.existingApplications;
    }

    public final OpenShiftApplicationWizardModel getWizardModel() {
        return this.wizardModel;
    }
}

