/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.viewer;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractDetailViews {
    protected final IDetailView emptyView;
    private Composite parent;
    private IDetailView currentView;
    private final StackLayout stackLayout;
    private DataBindingContext dbc;
    private IObservableValue detailViewModel;

    public AbstractDetailViews(IObservableValue detailViewModel, Composite parent, DataBindingContext dbc) {
        this.currentView = this.emptyView = new EmptyView();
        this.stackLayout = new StackLayout();
        Assert.isLegal((parent != null && !parent.isDisposed() ? 1 : 0) != 0);
        this.parent = parent;
        Assert.isLegal((dbc != null ? 1 : 0) != 0);
        this.dbc = dbc;
        Assert.isLegal((detailViewModel != null && !detailViewModel.isDisposed() ? 1 : 0) != 0);
        this.detailViewModel = detailViewModel;
    }

    public void createControls() {
        this.detailViewModel.addValueChangeListener(this.onDetailViewModelChanged());
        this.parent.setLayout((Layout)this.stackLayout);
        this.createViewControls(this.parent, this.dbc);
        this.showView(null, this.currentView, this.dbc);
    }

    protected abstract IDetailView[] getDetailViews();

    private IValueChangeListener onDetailViewModelChanged() {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractDetailViews.this.showView(event.getObservableValue(), AbstractDetailViews.this.dbc);
            }
        };
    }

    protected void showView(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
        this.showView(selectedCartridgeObservable, this.getView(selectedCartridgeObservable), dbc);
    }

    protected void showView(IObservableValue selectedCartridgeObservable, IDetailView view, DataBindingContext dbc) {
        if (view == null || view.getControl() == null) {
            return;
        }
        if (selectedCartridgeObservable == null) {
            return;
        }
        this.currentView.onInVisible(selectedCartridgeObservable, dbc);
        view.onVisible(selectedCartridgeObservable, dbc);
        this.stackLayout.topControl = view.getControl();
        this.parent.layout(true, true);
    }

    protected void createViewControls(Composite parent, DataBindingContext dbc) {
        IDetailView[] iDetailViewArray = this.getDetailViews();
        int n = iDetailViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailView detailView = iDetailViewArray[n2];
            detailView.createControls(parent, dbc);
            ++n2;
        }
    }

    protected IDetailView getView(IObservableValue selectedCartridgeObservable) {
        return this.getViewFor(selectedCartridgeObservable, this.getDetailViews());
    }

    protected IDetailView getViewFor(IObservableValue selectedCartridgeObservable, IDetailView ... detailViews) {
        Object value = selectedCartridgeObservable.getValue();
        IDetailView view = this.emptyView;
        IDetailView[] iDetailViewArray = detailViews;
        int n = detailViews.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailView detailView = iDetailViewArray[n2];
            if (detailView.isViewFor(value)) {
                view = detailView;
                break;
            }
            ++n2;
        }
        return view;
    }

    private abstract class BaseDetailsView
    implements IDetailView {
        private Composite control;

        private BaseDetailsView() {
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
        }

        @Override
        public void onInVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
        }

        @Override
        public Control getControl() {
            return this.control;
        }

        protected Composite setControl(Composite composite) {
            this.control = composite;
            return composite;
        }

        @Override
        public abstract boolean isViewFor(Object var1);
    }

    protected class EmptyView
    extends BaseDetailsView {
        protected EmptyView() {
        }

        @Override
        public Composite createControls(Composite parent, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(6, 6).spacing(6, 6).applyTo(container);
            return container;
        }

        @Override
        public boolean isViewFor(Object object) {
            return true;
        }
    }

    public static interface IDetailView {
        public Composite createControls(Composite var1, DataBindingContext var2);

        public void onVisible(IObservableValue var1, DataBindingContext var2);

        public void onInVisible(IObservableValue var1, DataBindingContext var2);

        public Control getControl();

        public boolean isViewFor(Object var1);
    }
}

