/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.openshift.express.internal.core.util.FileUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;

public class SSHUtils {
    private static final String SSH_PREFERENCE_PAGE_ID = "org.eclipse.jsch.ui.SSHPreferences";
    private static final String KEYS_SEPARATOR = ",";

    public static String getSSH2Home() {
        return JSchCorePlugin.getPlugin().getPluginPreferences().getString("SSH2HOME");
    }

    public static void setPrivateKeyPermissions(File privateKey) {
        privateKey.setReadable(false, false);
        privateKey.setWritable(false, false);
        privateKey.setReadable(true, true);
        privateKey.setWritable(true, true);
    }

    public static String[] getPrivateKeysFromPreferences() {
        String privateKeys = JSchCorePlugin.getPlugin().getPluginPreferences().getString("PRIVATEKEY");
        if (privateKeys != null && privateKeys.trim().length() > 0) {
            return privateKeys.split(KEYS_SEPARATOR);
        }
        return new String[0];
    }

    public static boolean isPrivateKeyForPublicKeyKnownToSsh(String publicKeyPath) {
        if (StringUtils.isEmpty((String)publicKeyPath)) {
            return false;
        }
        String[] stringArray = SSHUtils.getPrivateKeysFromPreferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String preferencesKey = stringArray[n2];
            try {
                File privateKey = SSHUtils.getKeyFile(preferencesKey);
                if (privateKey != null && FileUtils.canRead((File)privateKey) && (publicKeyPath.startsWith(String.valueOf(privateKey.getAbsolutePath()) + ".") || publicKeyPath.startsWith(String.valueOf(privateKey.getPath()) + "."))) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
            ++n2;
        }
        return false;
    }

    public static void addToPrivateKeysPreferences(File privateKey) {
        Preferences preferences = JSchCorePlugin.getPlugin().getPluginPreferences();
        String privateKeys = preferences.getString("PRIVATEKEY");
        String privateKeyPath = SSHUtils.getKeyPath(privateKey);
        privateKeys = privateKeys != null && privateKeys.trim().length() > 0 ? String.valueOf(privateKeys) + KEYS_SEPARATOR + privateKeyPath : privateKeyPath;
        preferences.setValue("PRIVATEKEY", privateKeys);
        JSchCorePlugin.getPlugin().setNeedToLoadKeys(true);
        JSchCorePlugin.getPlugin().savePluginPreferences();
    }

    private static String getKeyPath(File privateKey) {
        String ssh2Home = SSHUtils.getSSH2Home();
        if (ssh2Home == null || ssh2Home.isEmpty()) {
            return privateKey.getAbsolutePath();
        }
        if (!privateKey.getAbsolutePath().startsWith(ssh2Home)) {
            return privateKey.getAbsolutePath();
        }
        return privateKey.getName();
    }

    public static int openPreferencesPage(Shell shell) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)SSH_PREFERENCE_PAGE_ID, null, null);
        return dialog.open();
    }

    public static boolean publicKeyMatchesPrivateKeyInPreferences(File publicKey) {
        String[] stringArray = SSHUtils.getPrivateKeysFromPreferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String preferencesKey = stringArray[n2];
            try {
                File privateKey = SSHUtils.getKeyFile(preferencesKey.trim());
                if (privateKey != null && publicKey.getAbsolutePath().startsWith(String.valueOf(privateKey.getAbsolutePath()) + ".")) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
            ++n2;
        }
        return false;
    }

    public static File getKeyForRelativeOrAbsolutePath(String keyPath) throws FileNotFoundException {
        if (SSHUtils.isEmpty(keyPath)) {
            return null;
        }
        if (keyPath.startsWith(File.separator)) {
            return new File(keyPath);
        }
        return new File(SSHUtils.getSSH2Home(), keyPath);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static File getKeyFile(String keyName) throws FileNotFoundException {
        if (SSHUtils.isEmpty(keyName)) {
            return null;
        }
        if (keyName.startsWith(File.separator)) {
            return new File(keyName);
        }
        return new File(SSHUtils.getSSH2Home(), keyName);
    }
}

