/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;

public final class Logger {
    private static final String DEBUG = "org.jboss.tools.openshift.express.ui/debug";
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private Logger() {
    }

    public static void error(String message, Throwable t) {
        OpenShiftUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.express.ui", message, t));
    }

    public static void error(String message) {
        OpenShiftUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.openshift.express.ui", message));
    }

    public static void warn(String message, Throwable t) {
        OpenShiftUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.openshift.express.ui", message, t));
    }

    public static void warn(String message) {
        OpenShiftUIActivator.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.openshift.express.ui", message));
    }

    public static void info(String message) {
        OpenShiftUIActivator.getDefault().getLog().log((IStatus)new Status(1, "org.jboss.tools.openshift.express.ui", message));
    }

    public static void debug(String message) {
        String debugOption = Platform.getDebugOption((String)DEBUG);
        if (OpenShiftUIActivator.getDefault() == null) {
            return;
        }
        if (OpenShiftUIActivator.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption)) {
            System.out.println("[" + Thread.currentThread().getName() + "] " + message);
        }
    }

    public static void debug(String message, Object ... items) {
        String debugOption = Platform.getDebugOption((String)DEBUG);
        String valuedMessage = message;
        if (OpenShiftUIActivator.getDefault() != null && OpenShiftUIActivator.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption)) {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                valuedMessage = valuedMessage.replaceFirst("\\{\\}", item != null ? item.toString() : "null");
                ++n2;
            }
            System.out.println(String.valueOf(dateFormatter.get().format(new Date())) + " [" + Thread.currentThread().getName() + "] " + valuedMessage);
        }
    }
}

