/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;

public class WaitForApplicationJob
extends AbstractDelegatingMonitorJob {
    private static final int APP_REACHABLE_TIMEOUT = 180000;
    private IApplication application;
    private Shell shell;

    public WaitForApplicationJob(IApplication application, Shell shell) {
        super(NLS.bind((String)OpenShiftExpressUIMessages.WAITING_FOR_REACHABLE, (Object)application.getName()));
        this.shell = shell;
        this.application = application;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        Logger.debug(OpenShiftExpressUIMessages.WAITING_FOR_REACHABLE);
        try {
            while (!this.application.waitForAccessible(180000L)) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.openKeepWaitingDialog()) continue;
                return new Status(8, "org.jboss.tools.openshift.express.ui", 1, NLS.bind((String)OpenShiftExpressUIMessages.APPLICATION_NOT_ANSWERING, (Object)this.application.getName()), null);
            }
        }
        catch (OpenShiftException e) {
            return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)"Could not wait for application \"{0}\" to become reachable", (Object)this.application.getName()), e);
        }
        return Status.OK_STATUS;
    }

    protected boolean openKeepWaitingDialog() {
        final AtomicBoolean keepWaiting = new AtomicBoolean(false);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(WaitForApplicationJob.this.shell, NLS.bind((String)"Waiting for application {0}", (Object)WaitForApplicationJob.this.application.getName()), WaitForApplicationJob.this.shell.getDisplay().getSystemImage(4), NLS.bind((String)OpenShiftExpressUIMessages.APPLICATION_NOT_ANSWERING_CONTINUE_WAITING, (Object)WaitForApplicationJob.this.application.getName()), 3, new String[]{OpenShiftExpressUIMessages.BTN_KEEP_WAITING, OpenShiftExpressUIMessages.BTN_CLOSE_WIZARD}, 3);
                keepWaiting.set(dialog.open() == 0);
            }
        });
        return keepWaiting.get();
    }
}

