/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.IUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;

public class FireConnectionsChangedJob
extends AbstractDelegatingMonitorJob {
    private List<Connection> connections = new ArrayList<Connection>();
    private LoadApplicationJob job;

    public FireConnectionsChangedJob(LoadApplicationJob job) {
        super("Refreshing connections");
        this.job = job;
    }

    public FireConnectionsChangedJob(IUser user) {
        super(NLS.bind((String)"Refreshing connection {0}", (Object)user.getRhlogin()));
        this.add(this.createConnection(user));
    }

    public FireConnectionsChangedJob(List<IUser> users) {
        super(NLS.bind((String)"Refreshing {0} connections", (Object)users.size()));
        this.add(this.createConnections(users));
    }

    public FireConnectionsChangedJob(Connection connection) {
        super(NLS.bind((String)"Refreshing connection {0}", (Object)connection.getUsername()));
        this.add(connection);
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        for (Connection connection : this.getConnections()) {
            ConnectionsModelSingleton.getInstance().fireConnectionChanged(connection);
        }
        return Status.OK_STATUS;
    }

    private List<Connection> getConnections() {
        if (!this.connections.isEmpty()) {
            return this.connections;
        }
        if (this.job != null) {
            return Collections.singletonList(this.createConnection(this.job.getApplication()));
        }
        return Collections.emptyList();
    }

    private void add(List<Connection> connections) {
        for (Connection connection : connections) {
            this.add(connection);
        }
    }

    private void add(Connection connection) {
        if (connection != null) {
            this.connections.add(connection);
        }
    }

    private List<Connection> createConnections(List<IUser> users) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (users == null) {
            return connections;
        }
        for (IUser user : users) {
            connections.add(this.createConnection(user));
        }
        return connections;
    }

    private Connection createConnection(IUser user) {
        Connection connection = ConnectionsModelSingleton.getInstance().getConnectionByResource(user);
        return connection;
    }

    private Connection createConnection(IApplication application) {
        if (application == null || application.getDomain() == null) {
            return null;
        }
        return this.createConnection(application.getDomain().getUser());
    }
}

