/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.explorer;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.util.OpenShiftResourceLabelUtils;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.express.internal.ui.explorer.OpenShiftExplorerContentProvider;
import org.jboss.tools.openshift.express.internal.ui.messages.OpenShiftExpressUIMessages;

public class OpenShiftExplorerLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
ILabelProvider {
    private static final String DEFAULT_MARKER = "(default)";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof Connection) {
            image = OpenShiftImages.OPENSHIFT_LOGO_WHITE_ICON_IMG;
        } else if (element instanceof IDomain) {
            image = OpenShiftImages.GLOBE_IMG;
        } else if (element instanceof IApplication) {
            image = OpenShiftImages.QUERY_IMG;
        } else if (element instanceof IEmbeddedCartridge) {
            image = OpenShiftImages.TASK_REPO_IMG;
        } else if (element instanceof OpenShiftExplorerContentProvider.LoadingStub) {
            image = OpenShiftImages.SYSTEM_PROCESS_IMG;
        } else if (element instanceof OpenShiftException) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        return image;
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        StyledString styledString = null;
        if (element instanceof Connection) {
            styledString = this.createStyledString((Connection)element);
        } else if (element instanceof IDomain) {
            styledString = this.createStyledString((IDomain)element);
        } else if (element instanceof IApplication) {
            styledString = this.createStyledString((IApplication)element);
        } else if (element instanceof IEmbeddedCartridge) {
            styledString = this.createStyledString((IEmbeddedCartridge)element);
        } else if (element instanceof OpenShiftExplorerContentProvider.LoadingStub) {
            styledString = new StyledString(OpenShiftExpressUIMessages.LOADING_USER_APPLICATIONS_LABEL);
        } else if (element instanceof OpenShiftExplorerContentProvider.NotConnectedUserStub) {
            styledString = new StyledString(OpenShiftExpressUIMessages.USER_NOT_CONNECTED_LABEL);
        } else if (element instanceof OpenShiftException) {
            styledString = new StyledString(((OpenShiftException)((Object)element)).getMessage());
        }
        return styledString;
    }

    private StyledString createStyledString(Connection connection) {
        String name = connection.getUsername();
        String host = connection.getHost();
        StringBuilder builder = new StringBuilder(name).append(' ').append(host);
        if (connection.isDefaultHost()) {
            builder.append(' ').append(DEFAULT_MARKER);
        }
        String label = builder.toString();
        StyledString styledString = new StyledString(label);
        styledString.setStyle(name.length() + 1, builder.length() - name.length() - 1, StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IDomain domain) {
        String id = domain.getId();
        String fullName = OpenShiftResourceLabelUtils.toString((IDomain)domain);
        String label = id + ' ' + fullName;
        StyledString styledString = new StyledString(label);
        styledString.setStyle(id.length() + 1, fullName.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IApplication application) {
        String appName = application.getName();
        String appType = StringUtils.null2emptyString((String)OpenShiftResourceLabelUtils.toString((ICartridge)application.getCartridge()));
        StringBuilder sb = new StringBuilder(appName).append(' ').append(appType);
        StyledString styledString = new StyledString(sb.toString());
        styledString.setStyle(appName.length() + 1, appType.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private StyledString createStyledString(IEmbeddedCartridge cartridge) {
        String displayName = cartridge.getDisplayName();
        String name = cartridge.getName();
        StringBuilder sb = new StringBuilder(displayName).append(' ').append(name);
        StyledString styledString = new StyledString(sb.toString());
        styledString.setStyle(displayName.length() + 1, name.length(), StyledString.QUALIFIER_STYLER);
        return styledString;
    }
}

