/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.explorer;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModel;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.explorer.OpenShiftExplorerContentCategory;

public class OpenShiftExplorerContentProvider
implements ITreeContentProvider {
    private StructuredViewer viewer;
    private List<Object> loadedElements = new ArrayList<Object>();
    private List<Object> loadingElements = new ArrayList<Object>();
    private Map<Object, Exception> errors = new HashMap<Object, Exception>();

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)viewer;
    }

    public Object[] getElements(Object parentElement) {
        this.loadedElements.clear();
        this.loadingElements.clear();
        this.errors.clear();
        if (parentElement instanceof IWorkspaceRoot) {
            return ConnectionsModelSingleton.getInstance().getConnections();
        }
        if (parentElement instanceof ConnectionsModel) {
            Object[] connections = ((ConnectionsModel)parentElement).getConnections();
            return connections;
        }
        if (parentElement instanceof Connection) {
            List domains = ((Connection)parentElement).getDomains();
            return domains.toArray(new IDomain[domains.size()]);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Connection) {
            Connection connection = (Connection)parentElement;
            if (!connection.isConnected() && !connection.canPromptForPassword()) {
                return new Object[]{new NotConnectedUserStub()};
            }
            return this.loadChildren(parentElement);
        }
        if (parentElement instanceof IDomain) {
            return this.loadChildren(parentElement);
        }
        if (parentElement instanceof IApplication) {
            return this.loadChildren(parentElement);
        }
        return this.getChildrenFor(parentElement);
    }

    private Object[] loadChildren(Object parentElement) {
        if (!this.loadedElements.contains(parentElement)) {
            if (!this.loadingElements.contains(parentElement)) {
                this.launchLoadingJob(parentElement);
            }
            return new Object[]{new LoadingStub()};
        }
        Exception ose = this.errors.get(parentElement);
        if (ose != null) {
            return new Object[]{ose};
        }
        return this.getChildrenFor(parentElement);
    }

    private Object[] getChildrenFor(Object parentElement) {
        Object[] children = new Object[]{};
        try {
            if (parentElement instanceof OpenShiftExplorerContentCategory) {
                Connection user = ((OpenShiftExplorerContentCategory)parentElement).getUser();
                children = new Object[]{user};
            } else if (parentElement instanceof Connection) {
                Connection connection = (Connection)parentElement;
                children = connection.getDomains().toArray();
            } else if (parentElement instanceof IDomain) {
                IDomain domain = (IDomain)parentElement;
                children = domain.getApplications().toArray();
            } else if (parentElement instanceof IApplication) {
                children = ((IApplication)parentElement).getEmbeddedCartridges().toArray();
            }
        }
        catch (OpenShiftException e) {
            this.errors.put(parentElement, (Exception)((Object)e));
        }
        return children;
    }

    private void launchLoadingJob(final Object element) {
        Job job = new Job("Loading OpenShift resources..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Loading OpenShift resources...", -1);
                monitor.worked(1);
                OpenShiftExplorerContentProvider.this.loadingElements.add(element);
                OpenShiftExplorerContentProvider.this.getChildrenFor(element);
                OpenShiftExplorerContentProvider.this.loadedElements.add(element);
                OpenShiftExplorerContentProvider.this.loadingElements.remove(element);
                OpenShiftExplorerContentProvider.this.refreshViewerObject(element);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    private void refreshViewerObject(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OpenShiftExplorerContentProvider.this.viewer.refresh(object);
            }
        });
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Connection || element instanceof IDomain || element instanceof IApplication;
    }

    public static class LoadingStub {
    }

    public static class NotConnectedUserStub {
    }
}

