/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.databinding;

import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class ValidationStatusControlDecoration {
    private IObservableValue validationStatus;

    public ValidationStatusControlDecoration(ValidationStatusProvider provider) {
        this.validationStatus = provider.getValidationStatus();
    }

    public void showFor(Control control, int position) {
        ControlDecoration decoration = this.createDecoration(control, position);
        IValueChangeListener validationStatusListener = this.onValidationStatusChanged(decoration);
        this.validationStatus.addValueChangeListener(validationStatusListener);
        control.addDisposeListener(this.onControlDisposed(validationStatusListener));
    }

    private ControlDecoration createDecoration(Control control, int position) {
        ControlDecoration controlDecoration = new ControlDecoration(control, position);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        if (this.validationStatus.getValue() instanceof IStatus) {
            this.showDecoration(controlDecoration, (IStatus)this.validationStatus.getValue());
        }
        return controlDecoration;
    }

    private DisposeListener onControlDisposed(final IValueChangeListener validationStatusListener) {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ValidationStatusControlDecoration.this.validationStatus.removeValueChangeListener(validationStatusListener);
            }
        };
    }

    private IValueChangeListener onValidationStatusChanged(final ControlDecoration controlDecoration) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (!(event.diff.getNewValue() instanceof IStatus)) {
                    return;
                }
                IStatus validationStatus = (IStatus)event.diff.getNewValue();
                ValidationStatusControlDecoration.this.showDecoration(controlDecoration, validationStatus);
            }
        };
    }

    private void showDecoration(ControlDecoration controlDecoration, IStatus validationStatus) {
        if (validationStatus.isOK()) {
            controlDecoration.hide();
        } else {
            controlDecoration.show();
        }
    }
}

