/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.databinding;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.osgi.util.NLS;

public class MultiConverter
implements IConverter {
    private IConverter[] converters;

    public MultiConverter(IConverter ... converters) {
        this.validate(converters);
        this.converters = converters;
    }

    private void validate(IConverter[] converters) {
        if (!this.hasConverters(converters)) {
            return;
        }
        Class fromType = null;
        IConverter[] iConverterArray = converters;
        int n = converters.length;
        int n2 = 0;
        while (n2 < n) {
            IConverter converter = iConverterArray[n2];
            if (fromType != null) {
                if (converter == null) {
                    throw new IllegalArgumentException("Null converter given.");
                }
                if (converter.getFromType() instanceof Class) {
                    throw new IllegalArgumentException(NLS.bind((String)"Converter {0} is not set to convert from a class (type).", converter.getClass()));
                }
                if (!fromType.isAssignableFrom((Class)converter.getFromType())) {
                    throw new IllegalArgumentException(NLS.bind((String)"Converter {0} does not match preceeding converter. It expects {1} and precedessor converts to {2}", (Object[])new Object[]{converter.getClass(), converter.getFromType(), fromType}));
                }
                fromType = (Class)converter.getToType();
            }
            ++n2;
        }
    }

    public Object convert(Object fromObject) {
        IConverter[] iConverterArray = this.converters;
        int n = this.converters.length;
        int n2 = 0;
        while (n2 < n) {
            IConverter converter = iConverterArray[n2];
            fromObject = converter.convert(fromObject);
            ++n2;
        }
        return fromObject;
    }

    public Object getFromType() {
        if (!this.hasConverters()) {
            return Object.class;
        }
        return this.converters[0].getFromType();
    }

    public Object getToType() {
        if (!this.hasConverters()) {
            return Object.class;
        }
        return this.converters[this.converters.length - 1].getToType();
    }

    private boolean hasConverters() {
        return this.hasConverters(this.converters);
    }

    private boolean hasConverters(IConverter[] converters) {
        return converters != null && converters.length > 0;
    }
}

