/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.express.internal.core.util.JobChainBuilder;
import org.jboss.tools.openshift.express.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.UIUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.details.ApplicationDetailsDialog;

public class ApplicationDetailsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplication application = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (application != null) {
            this.openApplicationDetailsDialog(application, shell);
        } else {
            IServer server = UIUtils.getFirstElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event), IServer.class);
            this.openApplicationDetailsDialog(server, shell);
        }
        return Status.OK_STATUS;
    }

    protected void openApplicationDetailsDialog(final IServer server, final Shell shell) {
        if (server == null) {
            return;
        }
        final LoadApplicationJob applicationJob = new LoadApplicationJob(server);
        new JobChainBuilder((Job)applicationJob).runWhenSuccessfullyDone((Job)new UIJob(NLS.bind((String)"Displaying application details", (Object)server.getName())){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IApplication application = applicationJob.getApplication();
                if (application == null) {
                    return OpenShiftUIActivator.createCancelStatus("Could not display details for application {0}. Application not found.", server.getName());
                }
                ApplicationDetailsHandler.this.openApplicationDetailsDialog(application, shell);
                return Status.OK_STATUS;
            }
        }).schedule();
    }

    protected void openApplicationDetailsDialog(IApplication application, Shell shell) {
        new ApplicationDetailsDialog(application, shell).open();
    }
}

