/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui;

import com.openshift.client.IHttpClient;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.jboss.tools.openshift.express.core.IConsoleUtility;
import org.jboss.tools.openshift.express.core.ICredentialsPrompter;
import org.jboss.tools.openshift.express.core.IQuestionHandler;
import org.jboss.tools.openshift.express.core.OpenshiftCoreUIIntegration;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.ui.QuestionHandler;
import org.jboss.tools.openshift.express.internal.ui.console.ConsoleUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.CredentialsPrompter;
import org.jboss.tools.openshift.express.internal.ui.wizard.connection.SSLCertificateCallback;
import org.osgi.framework.BundleContext;

public class OpenShiftUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.openshift.express.ui";
    private static OpenShiftUIActivator plugin;
    private IPreferenceStore corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.jboss.tools.openshift.express.core");

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initCoreUIIntegration();
    }

    protected void initCoreUIIntegration() {
        OpenshiftCoreUIIntegration.getDefault().setQuestionHandler((IQuestionHandler)new QuestionHandler());
        OpenshiftCoreUIIntegration.getDefault().setConsoleUtility((IConsoleUtility)new ConsoleUtils());
        OpenshiftCoreUIIntegration.getDefault().setCredentialPrompter((ICredentialsPrompter)new CredentialsPrompter());
        OpenshiftCoreUIIntegration.getDefault().setSSLCertificateAuthorization((IHttpClient.ISSLCertificateCallback)new SSLCertificateCallback());
    }

    public void stop(BundleContext context) throws Exception {
        ConnectionsModelSingleton.getInstance().save();
        plugin = null;
        super.stop(context);
    }

    public static OpenShiftUIActivator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(String message) {
        OpenShiftUIActivator.log(message, null);
    }

    public static void log(Throwable e) {
        OpenShiftUIActivator.log(e.getMessage(), e);
    }

    public static void log(String message, Throwable e) {
        OpenShiftUIActivator.log((IStatus)new Status(4, PLUGIN_ID, 4, message, e));
    }

    public static IStatus createCancelStatus(String message) {
        return new Status(8, PLUGIN_ID, message);
    }

    public static IStatus createCancelStatus(String message, Object ... arguments) {
        return new Status(8, PLUGIN_ID, NLS.bind((String)message, (Object[])arguments));
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PLUGIN_ID, message);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, message, throwable);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable, Object ... arguments) {
        return OpenShiftUIActivator.createErrorStatus(NLS.bind((String)message, (Object[])arguments), throwable);
    }

    public static MultiStatus createMultiStatus(String message, Throwable t, Object ... arguments) {
        MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 4, NLS.bind((String)message, (Object[])arguments), t);
        OpenShiftUIActivator.addStatuses(t, multiStatus);
        return multiStatus;
    }

    private static void addStatuses(Throwable t, MultiStatus multiStatus) {
        Throwable wrapped = OpenShiftUIActivator.getWrappedThrowable(t);
        if (wrapped != null) {
            multiStatus.add(OpenShiftUIActivator.createErrorStatus(wrapped.getMessage(), wrapped));
            OpenShiftUIActivator.addStatuses(wrapped, multiStatus);
        }
    }

    private static Throwable getWrappedThrowable(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof Exception) {
            return ((Exception)t).getCause();
        }
        return null;
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            this.corePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.jboss.tools.openshift.express.core");
        }
        return this.corePreferenceStore;
    }
}

