/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.seam.text.ext.CDISeamExtPlugin;
import org.jboss.tools.cdi.seam.text.ext.hyperlink.CDISeamResourceLoadingHyperlink;

public class CDISeamResourceLoadingHyperlinkDetector
extends AbstractHyperlinkDetector {
    public static final String RESOURCE_ANNOTATION_30 = "org.jboss.seam.solder.resourceLoader.Resource";
    public static final String RESOURCE_ANNOTATION_31 = "org.jboss.solder.resourceLoader.Resource";
    public static final String VALUE = "value";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        int offset = region.getOffset();
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource r = input.getResource();
        if (!(r instanceof IFile) || !r.exists() || r.getName().endsWith(".jar")) {
            return null;
        }
        IFile file = (IFile)r;
        try {
            IJavaElement element = input.getElementAt(offset);
            if (element != null && element instanceof IField) {
                IAnnotation annotation = CDIMarkerResolutionUtils.findAnnotation((IJavaElement)element, (String)RESOURCE_ANNOTATION_30);
                if (annotation == null || !annotation.exists()) {
                    annotation = CDIMarkerResolutionUtils.findAnnotation((IJavaElement)element, (String)RESOURCE_ANNOTATION_31);
                }
                if (annotation != null && annotation.exists()) {
                    IRegion annotationRegion = this.getAnnotationRegion(document, annotation);
                    String text = this.getValue(annotation);
                    if (text != null) {
                        return new IHyperlink[]{new CDISeamResourceLoadingHyperlink(file, document, annotationRegion, text)};
                    }
                }
            }
        }
        catch (CoreException ex) {
            CDISeamExtPlugin.getDefault().logError(ex);
        }
        catch (BadLocationException ex) {
            CDISeamExtPlugin.getDefault().logError(ex);
        }
        return null;
    }

    private IRegion getAnnotationRegion(IDocument document, IAnnotation annotation) throws BadLocationException, JavaModelException {
        int last;
        ISourceRange sourceRange = annotation.getSourceRange();
        String annotationText = document.get(sourceRange.getOffset(), sourceRange.getLength());
        int offset = sourceRange.getOffset();
        int length = sourceRange.getLength();
        int first = annotationText.indexOf("\"");
        if (first >= 0 && (last = annotationText.lastIndexOf("\"")) > 0 && last != first) {
            offset += first + 1;
            length = last - first - 1;
        }
        Region region = new Region(offset, length);
        return region;
    }

    private String getValue(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] pairs;
        IMemberValuePair[] iMemberValuePairArray = pairs = annotation.getMemberValuePairs();
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (pair.getMemberName().equals(VALUE) && pair.getValueKind() == 9) {
                return (String)pair.getValue();
            }
            ++n2;
        }
        return null;
    }
}

