/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DirectorySelectionGroup
extends Group {
    private static final String SETTINGS_KEY_DESTINATION_HISTORY = "destinationHistory";
    private static final int DESTINATION_HISTORY_LENGTH = 5;
    private Combo destinationCombo;
    private String[] destinationHistory;
    private String fallback;

    public DirectorySelectionGroup(Composite parent, int style) {
        super(parent, style);
        this.createGroup();
    }

    private void createGroup() {
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblDirectory = new Label((Composite)this, 0);
        lblDirectory.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDirectory.setText("Directory:");
        this.destinationCombo = new Combo((Composite)this, 0);
        this.destinationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectorySelectionGroup.this.sendModifyEvent();
            }
        });
        this.destinationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowse = new Button((Composite)this, 8);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectorySelectionGroup.this.chooseDirectory();
            }
        });
        btnBrowse.setText("Browse...");
    }

    protected void checkSubclass() {
    }

    private void sendModifyEvent() {
        Event e = new Event();
        e.widget = this;
        e.text = this.destinationCombo.getText();
        this.notifyListeners(24, e);
    }

    private void chooseDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText("Select Destination");
        dialog.setMessage("Select a destination directory");
        String directory = dialog.open();
        if (directory != null) {
            this.destinationCombo.setText(directory);
            this.sendModifyEvent();
        }
    }

    public void setComboValues(String ... newValues) {
        this.destinationCombo.removeAll();
        if (newValues == null) {
            return;
        }
        int i = 0;
        while (i < newValues.length) {
            this.destinationCombo.add(newValues[i], i);
            ++i;
        }
        if (this.destinationCombo.getItemCount() > 0) {
            this.destinationCombo.select(0);
        }
    }

    public String getValue() {
        return this.destinationCombo.getText();
    }

    public void saveHistory(IDialogSettings settings) {
        if (settings == null) {
            return;
        }
        if (this.destinationHistory == null) {
            this.destinationHistory = new String[0];
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(this.destinationHistory));
        String directory = this.destinationCombo.getText();
        l.remove(directory);
        l.add(directory);
        if (l.size() > 5) {
            l.remove(5);
        }
        this.destinationHistory = l.toArray(new String[l.size()]);
        this.setComboValues(this.destinationHistory);
        settings.put(SETTINGS_KEY_DESTINATION_HISTORY, this.destinationHistory);
    }

    public void restoreHistory(IDialogSettings settings) {
        String[] history;
        if (this.fallback != null) {
            this.destinationHistory = new String[]{this.fallback};
        }
        if (settings != null && (history = settings.getArray(SETTINGS_KEY_DESTINATION_HISTORY)) != null && history.length > 0) {
            this.destinationHistory = history;
        }
        this.setComboValues(this.destinationHistory);
    }

    public void setDefaultValue(String defaultValue) {
        this.fallback = defaultValue;
    }

    public static boolean isValidDirectory(File dstFile) {
        if (dstFile == null) {
            return false;
        }
        try {
            return !dstFile.getCanonicalPath().isEmpty();
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

