/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.eclipse.thym.core.plugin.RestorableCordovaPlugin;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryManager;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPlugin;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginVersion;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PluginRestoreOperation
extends WorkspaceModifyOperation {
    private final RestorableCordovaPlugin[] restorables;
    private final HybridProject project;

    public PluginRestoreOperation(HybridProject project, RestorableCordovaPlugin[] restorables) {
        this.restorables = restorables;
        this.project = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.restorables == null || this.restorables.length < 1) {
            HybridUI.log(2, "The restorables list is null or empty, aborting restore operation", null);
            return;
        }
        CordovaPluginManager pman = this.project.getPluginManager();
        FileOverwriteCallback cb = new FileOverwriteCallback(){

            public boolean isOverwiteAllowed(String[] files) {
                return true;
            }
        };
        RestorableCordovaPlugin[] restorableCordovaPluginArray = this.restorables;
        int n = this.restorables.length;
        int n2 = 0;
        while (n2 < n) {
            RestorableCordovaPlugin feature = restorableCordovaPluginArray[n2];
            switch (feature.getType()) {
                case REGISTRY: {
                    CordovaRegistryPluginVersion version = this.getVersion(feature);
                    if (version == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", NLS.bind((String)"Version {0} for Cordova plugin {1} does not exist on registry", (Object[])new String[]{feature.getVersion()})));
                    }
                    pman.installPlugin(version, cb, false, monitor);
                    break;
                }
                case GIT: {
                    try {
                        pman.installPlugin(new URI(feature.getUrl()), cb, false, monitor);
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", NLS.bind((String)"{0} is not a valid URI to restore Cordova plug-ins from Git", (Object)feature.getUrl()), (Throwable)e));
                    }
                }
                case LOCAL: {
                    pman.installPlugin(new File(feature.getPath()), cb, monitor);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown plugin restore type");
                }
            }
            ++n2;
        }
    }

    private CordovaRegistryPluginVersion getVersion(RestorableCordovaPlugin restorable) throws CoreException {
        CordovaPluginRegistryManager regMng = new CordovaPluginRegistryManager("http://registry.cordova.io/");
        CordovaRegistryPlugin plugin = regMng.getCordovaPluginInfo(restorable.getId());
        String version = restorable.getVersion();
        if (version == null) {
            version = plugin.getLatestVersion();
        }
        return plugin.getVersion(version);
    }
}

