/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CordovaPluginWizardResources {
    private static final String COLOR_DARK_GRAY = "dark_gray";
    private static final String COLOR_DARK_LIST_BACKGROUND = "dark_list_background";
    private final ResourceManager resourceManager;
    private final FontDescriptor h1FontDescriptor;
    private final FontDescriptor h2FontDescriptor;
    private final FontDescriptor subFontDescriptor;
    private Color colorDisabled;
    private Color darkListBackground;

    public CordovaPluginWizardResources(Display display) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        this.h1FontDescriptor = this.createFontDescriptor(1, 1.25f);
        this.h2FontDescriptor = this.createFontDescriptor(1, 1.15f);
        this.subFontDescriptor = this.createFontDescriptor(0, 0.75f);
    }

    private FontDescriptor createFontDescriptor(int style, float heightMultiplier) {
        Font baseFont = JFaceResources.getDialogFont();
        FontData[] fontData = baseFont.getFontData();
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < newFontData.length) {
            newFontData[i] = new FontData(fontData[i].getName(), (int)((float)fontData[i].getHeight() * heightMultiplier), fontData[i].getStyle() | style);
            ++i;
        }
        return FontDescriptor.createFrom((FontData[])newFontData);
    }

    public Font getHeaderFont() {
        return this.resourceManager.createFont(this.h1FontDescriptor);
    }

    public Font getSmallHeaderFont() {
        return this.resourceManager.createFont(this.h2FontDescriptor);
    }

    public Font getSubTextFont() {
        return this.resourceManager.createFont(this.subFontDescriptor);
    }

    public Color getDisabledColor() {
        if (this.colorDisabled == null) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_DARK_GRAY)) {
                colorRegistry.put(COLOR_DARK_GRAY, new RGB(105, 105, 105));
            }
            this.colorDisabled = colorRegistry.get(COLOR_DARK_GRAY);
        }
        return this.colorDisabled;
    }

    public Color getDarkListBackGroundColor() {
        if (this.darkListBackground == null) {
            Color lightColor = PlatformUI.getWorkbench().getDisplay().getSystemColor(25);
            int shift = -10;
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_DARK_LIST_BACKGROUND)) {
                RGB darkRGB = new RGB(Math.max(0, lightColor.getRed() + shift), Math.max(0, lightColor.getGreen() + shift), Math.max(0, lightColor.getBlue() + shift));
                JFaceResources.getColorRegistry().put(COLOR_DARK_LIST_BACKGROUND, darkRGB);
            }
            this.darkListBackground = colorRegistry.get(COLOR_DARK_LIST_BACKGROUND);
        }
        return this.darkListBackground;
    }
}

