/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.status;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.status.AbstractStatusHandler;

public class HybridMobileStatusExtension {
    private static final String ATTR_PLUGIN = "plugin";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CODE = "code";
    public static final String EXTENSION_POINT_ID = "org.eclipse.thym.ui.hybridMobileStatusHandler";
    private int code;
    private String plugin;
    private AbstractStatusHandler handler;

    public HybridMobileStatusExtension(IConfigurationElement configurationElement) {
        this.code = Integer.parseInt(configurationElement.getAttribute(ATTR_CODE));
        try {
            this.handler = (AbstractStatusHandler)configurationElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException e) {
            HybridUI.log(4, "Status Handler can not be instantiated ", e);
        }
        this.plugin = configurationElement.getAttribute(ATTR_PLUGIN);
    }

    public int getCode() {
        return this.code;
    }

    public String getPluginID() {
        return this.plugin;
    }

    public AbstractStatusHandler getHandler() {
        if (this.handler == null) {
            throw new IllegalStateException("A status handler could not be initiated. See error logs for details.");
        }
        return this.handler;
    }
}

